/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.utils;

import io.github.jy95.fds.common.types.AbstractTranslatorsMap;
import io.github.jy95.fds.common.types.DisplayOrder;
import io.github.jy95.fds.common.types.Translator;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.translators.AdditionalInstructionR4;
import io.github.jy95.fds.r4.translators.AsNeededR4;
import io.github.jy95.fds.r4.translators.BoundsDurationR4;
import io.github.jy95.fds.r4.translators.BoundsPeriodR4;
import io.github.jy95.fds.r4.translators.BoundsRangeR4;
import io.github.jy95.fds.r4.translators.CountCountMaxR4;
import io.github.jy95.fds.r4.translators.DayOfWeekR4;
import io.github.jy95.fds.r4.translators.DoseQuantityR4;
import io.github.jy95.fds.r4.translators.DoseRangeR4;
import io.github.jy95.fds.r4.translators.DurationDurationMaxR4;
import io.github.jy95.fds.r4.translators.ExtensionR4;
import io.github.jy95.fds.r4.translators.FrequencyFrequencyMaxPeriodPeriodMaxR4;
import io.github.jy95.fds.r4.translators.FrequencyFrequencyMaxR4;
import io.github.jy95.fds.r4.translators.MaxDosePerAdministrationR4;
import io.github.jy95.fds.r4.translators.MaxDosePerLifetimeR4;
import io.github.jy95.fds.r4.translators.MaxDosePerPeriodR4;
import io.github.jy95.fds.r4.translators.MethodR4;
import io.github.jy95.fds.r4.translators.ModifierExtensionR4;
import io.github.jy95.fds.r4.translators.OffsetWhenR4;
import io.github.jy95.fds.r4.translators.PatientInstructionR4;
import io.github.jy95.fds.r4.translators.PeriodPeriodMaxR4;
import io.github.jy95.fds.r4.translators.RateQuantityR4;
import io.github.jy95.fds.r4.translators.RateRangeR4;
import io.github.jy95.fds.r4.translators.RateRatioR4;
import io.github.jy95.fds.r4.translators.RouteR4;
import io.github.jy95.fds.r4.translators.SiteR4;
import io.github.jy95.fds.r4.translators.TextR4;
import io.github.jy95.fds.r4.translators.TimeOfDayR4;
import io.github.jy95.fds.r4.translators.TimingCodeR4;
import io.github.jy95.fds.r4.translators.TimingEventR4;
import io.github.jy95.fds.r4.translators.TimingExtensionR4;
import io.github.jy95.fds.r4.translators.TimingModifierExtensionR4;
import io.github.jy95.fds.r4.translators.TimingRepeatExtensionR4;
import java.util.EnumMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Dosage;

public class TranslatorsMapR4
extends AbstractTranslatorsMap<FDSConfigR4, Dosage> {
    public TranslatorsMapR4(FDSConfigR4 config, ResourceBundle bundle) {
        super(TranslatorsMapR4.createTranslatorsSuppliers(config, bundle));
    }

    private static Map<DisplayOrder, Supplier<Translator<FDSConfigR4, Dosage>>> createTranslatorsSuppliers(FDSConfigR4 config, ResourceBundle bundle) {
        EnumMap<DisplayOrder, Supplier<Translator<FDSConfigR4, Dosage>>> suppliers = new EnumMap<DisplayOrder, Supplier<Translator<FDSConfigR4, Dosage>>>(DisplayOrder.class);
        suppliers.put(DisplayOrder.TEXT, TextR4::new);
        suppliers.put(DisplayOrder.PATIENT_INSTRUCTION, PatientInstructionR4::new);
        suppliers.put(DisplayOrder.DAY_OF_WEEK, () -> new DayOfWeekR4(config, bundle));
        suppliers.put(DisplayOrder.TIME_OF_DAY, () -> new TimeOfDayR4(config, bundle));
        suppliers.put(DisplayOrder.TIMING_CODE, () -> new TimingCodeR4(config));
        suppliers.put(DisplayOrder.TIMING_EVENT, () -> new TimingEventR4(config, bundle));
        suppliers.put(DisplayOrder.METHOD, () -> new MethodR4(config));
        suppliers.put(DisplayOrder.ROUTE, () -> new RouteR4(config));
        suppliers.put(DisplayOrder.SITE, () -> new SiteR4(config));
        suppliers.put(DisplayOrder.EXTENSION, () -> new ExtensionR4(config));
        suppliers.put(DisplayOrder.TIMING_EXTENSION, () -> new TimingExtensionR4(config));
        suppliers.put(DisplayOrder.TIMING_REPEAT_EXTENSION, () -> new TimingRepeatExtensionR4(config));
        suppliers.put(DisplayOrder.MODIFIER_EXTENSION, () -> new ModifierExtensionR4(config));
        suppliers.put(DisplayOrder.TIMING_MODIFIER_EXTENSION, () -> new TimingModifierExtensionR4(config));
        suppliers.put(DisplayOrder.ADDITIONAL_INSTRUCTION, () -> new AdditionalInstructionR4(config, bundle));
        suppliers.put(DisplayOrder.AS_NEEDED, () -> new AsNeededR4(config, bundle));
        suppliers.put(DisplayOrder.BOUNDS_PERIOD, () -> new BoundsPeriodR4(config, bundle));
        suppliers.put(DisplayOrder.BOUNDS_RANGE, () -> new BoundsRangeR4(config, bundle));
        suppliers.put(DisplayOrder.DURATION_DURATION_MAX, () -> new DurationDurationMaxR4(config, bundle));
        suppliers.put(DisplayOrder.FREQUENCY_FREQUENCY_MAX, () -> new FrequencyFrequencyMaxR4(config, bundle));
        suppliers.put(DisplayOrder.PERIOD_PERIOD_MAX, () -> new PeriodPeriodMaxR4(config, bundle));
        suppliers.put(DisplayOrder.COUNT_COUNT_MAX, () -> new CountCountMaxR4(config, bundle));
        suppliers.put(DisplayOrder.DOSE_QUANTITY, () -> new DoseQuantityR4(config, bundle));
        suppliers.put(DisplayOrder.DOSE_RANGE, () -> new DoseRangeR4(config, bundle));
        suppliers.put(DisplayOrder.RATE_QUANTITY, () -> new RateQuantityR4(config, bundle));
        suppliers.put(DisplayOrder.RATE_RANGE, () -> new RateRangeR4(config, bundle));
        suppliers.put(DisplayOrder.RATE_RATIO, () -> new RateRatioR4(config, bundle));
        suppliers.put(DisplayOrder.OFFSET_WHEN, () -> new OffsetWhenR4(bundle, config.getLocale()));
        suppliers.put(DisplayOrder.MAX_DOSE_PER_LIFETIME, () -> new MaxDosePerLifetimeR4(config, bundle));
        suppliers.put(DisplayOrder.MAX_DOSE_PER_ADMINISTRATION, () -> new MaxDosePerAdministrationR4(config, bundle));
        suppliers.put(DisplayOrder.MAX_DOSE_PER_PERIOD, () -> new MaxDosePerPeriodR4(config, bundle));
        suppliers.put(DisplayOrder.BOUNDS_DURATION, () -> new BoundsDurationR4(config, bundle));
        suppliers.put(DisplayOrder.FREQUENCY_FREQUENCY_MAX_PERIOD_PERIOD_MAX, () -> new FrequencyFrequencyMaxPeriodPeriodMaxR4((Translator<FDSConfigR4, Dosage>)((Translator)((Supplier)suppliers.get(DisplayOrder.FREQUENCY_FREQUENCY_MAX)).get()), (Translator<FDSConfigR4, Dosage>)((Translator)((Supplier)suppliers.get(DisplayOrder.PERIOD_PERIOD_MAX)).get())));
        return suppliers;
    }
}

