/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5;

import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.functions.SequenceUtils;
import io.github.jy95.fds.common.types.DisplayOrder;
import io.github.jy95.fds.common.types.DosageAPI;
import io.github.jy95.fds.common.types.Translator;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.utils.TranslatorsMapR5;
import java.util.List;
import java.util.ResourceBundle;
import org.hl7.fhir.r5.model.Dosage;

public class DosageAPIR5
extends DosageAPI<FDSConfigR5, Dosage> {
    private final TranslatorsMapR5 translatorsMapR5;

    public DosageAPIR5() {
        this((FDSConfigR5)FDSConfigR5.builder().build());
    }

    public DosageAPIR5(FDSConfigR5 config) {
        super((FDSConfig)config);
        ResourceBundle bundle = (ResourceBundle)config.getSelectResourceBundle().apply(config.getLocale());
        this.translatorsMapR5 = new TranslatorsMapR5(config, bundle);
    }

    public Translator<FDSConfigR5, Dosage> getTranslator(DisplayOrder displayOrder) {
        return this.translatorsMapR5.getTranslator(displayOrder);
    }

    public boolean containsOnlySequentialInstructions(List<Dosage> dosages) {
        return SequenceUtils.containsOnlySequentialInstructions(dosages, Dosage::getSequence);
    }

    protected List<List<Dosage>> groupBySequence(List<Dosage> dosages) {
        return SequenceUtils.groupBySequence(dosages, Dosage::getSequence);
    }
}

