/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.config;

import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.common.types.FDSOperations;
import io.github.jy95.fds.r5.config.DefaultImplementationsR5;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Quantity;

public class FDSConfigR5
extends FDSConfig
implements FDSOperations<Quantity, CodeableConcept, Extension, Dosage, Dosage.DosageDoseAndRateComponent, DataType> {
    private final Function<Quantity, CompletableFuture<String>> fromFHIRQuantityUnitToString;
    private final Function<CodeableConcept, CompletableFuture<String>> fromCodeableConceptToString;
    private final Function<List<Extension>, CompletableFuture<String>> fromExtensionsToString;
    private final BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, DataType> selectDosageAndRateField;
    private final BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> hasMatchingComponent;

    public CompletableFuture<String> fromFHIRQuantityUnitToString(Quantity quantity) {
        return this.fromFHIRQuantityUnitToString.apply(quantity);
    }

    public CompletableFuture<String> fromCodeableConceptToString(CodeableConcept codeableConcept) {
        return this.fromCodeableConceptToString.apply(codeableConcept);
    }

    public CompletableFuture<String> fromExtensionsToString(List<Extension> extensions) {
        return this.fromExtensionsToString.apply(extensions);
    }

    public DataType selectDosageAndRateField(List<Dosage.DosageDoseAndRateComponent> doseAndRateComponentList, DoseAndRateKey doseAndRateKey) {
        return this.selectDosageAndRateField.apply(doseAndRateComponentList, doseAndRateKey);
    }

    public boolean hasMatchingComponent(Dosage dosage, Predicate<Dosage.DosageDoseAndRateComponent> predicate) {
        return this.hasMatchingComponent.apply(dosage, predicate);
    }

    @Generated
    private static Function<Quantity, CompletableFuture<String>> $default$fromFHIRQuantityUnitToString() {
        return DefaultImplementationsR5::fromFHIRQuantityUnitToString;
    }

    @Generated
    private static Function<CodeableConcept, CompletableFuture<String>> $default$fromCodeableConceptToString() {
        return DefaultImplementationsR5::fromCodeableConceptToString;
    }

    @Generated
    private static Function<List<Extension>, CompletableFuture<String>> $default$fromExtensionsToString() {
        return DefaultImplementationsR5::fromExtensionsToString;
    }

    @Generated
    private static BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, DataType> $default$selectDosageAndRateField() {
        return DefaultImplementationsR5::selectDosageAndRateField;
    }

    @Generated
    private static BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> $default$hasMatchingComponent() {
        return DefaultImplementationsR5::hasMatchingComponent;
    }

    @Generated
    protected FDSConfigR5(FDSConfigR5Builder<?, ?> b) {
        super(b);
        this.fromFHIRQuantityUnitToString = b.fromFHIRQuantityUnitToString$set ? b.fromFHIRQuantityUnitToString$value : FDSConfigR5.$default$fromFHIRQuantityUnitToString();
        this.fromCodeableConceptToString = b.fromCodeableConceptToString$set ? b.fromCodeableConceptToString$value : FDSConfigR5.$default$fromCodeableConceptToString();
        this.fromExtensionsToString = b.fromExtensionsToString$set ? b.fromExtensionsToString$value : FDSConfigR5.$default$fromExtensionsToString();
        this.selectDosageAndRateField = b.selectDosageAndRateField$set ? b.selectDosageAndRateField$value : FDSConfigR5.$default$selectDosageAndRateField();
        this.hasMatchingComponent = b.hasMatchingComponent$set ? b.hasMatchingComponent$value : FDSConfigR5.$default$hasMatchingComponent();
    }

    @Generated
    public static FDSConfigR5Builder<?, ?> builder() {
        return new FDSConfigR5BuilderImpl();
    }

    @Generated
    public Function<Quantity, CompletableFuture<String>> getFromFHIRQuantityUnitToString() {
        return this.fromFHIRQuantityUnitToString;
    }

    @Generated
    public Function<CodeableConcept, CompletableFuture<String>> getFromCodeableConceptToString() {
        return this.fromCodeableConceptToString;
    }

    @Generated
    public Function<List<Extension>, CompletableFuture<String>> getFromExtensionsToString() {
        return this.fromExtensionsToString;
    }

    @Generated
    public BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, DataType> getSelectDosageAndRateField() {
        return this.selectDosageAndRateField;
    }

    @Generated
    public BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> getHasMatchingComponent() {
        return this.hasMatchingComponent;
    }

    @Generated
    public static abstract class FDSConfigR5Builder<C extends FDSConfigR5, B extends FDSConfigR5Builder<C, B>>
    extends FDSConfig.FDSConfigBuilder<C, B> {
        @Generated
        private boolean fromFHIRQuantityUnitToString$set;
        @Generated
        private Function<Quantity, CompletableFuture<String>> fromFHIRQuantityUnitToString$value;
        @Generated
        private boolean fromCodeableConceptToString$set;
        @Generated
        private Function<CodeableConcept, CompletableFuture<String>> fromCodeableConceptToString$value;
        @Generated
        private boolean fromExtensionsToString$set;
        @Generated
        private Function<List<Extension>, CompletableFuture<String>> fromExtensionsToString$value;
        @Generated
        private boolean selectDosageAndRateField$set;
        @Generated
        private BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, DataType> selectDosageAndRateField$value;
        @Generated
        private boolean hasMatchingComponent$set;
        @Generated
        private BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> hasMatchingComponent$value;

        @Generated
        public B fromFHIRQuantityUnitToString(Function<Quantity, CompletableFuture<String>> fromFHIRQuantityUnitToString) {
            this.fromFHIRQuantityUnitToString$value = fromFHIRQuantityUnitToString;
            this.fromFHIRQuantityUnitToString$set = true;
            return (B)this.self();
        }

        @Generated
        public B fromCodeableConceptToString(Function<CodeableConcept, CompletableFuture<String>> fromCodeableConceptToString) {
            this.fromCodeableConceptToString$value = fromCodeableConceptToString;
            this.fromCodeableConceptToString$set = true;
            return (B)this.self();
        }

        @Generated
        public B fromExtensionsToString(Function<List<Extension>, CompletableFuture<String>> fromExtensionsToString) {
            this.fromExtensionsToString$value = fromExtensionsToString;
            this.fromExtensionsToString$set = true;
            return (B)this.self();
        }

        @Generated
        public B selectDosageAndRateField(BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, DataType> selectDosageAndRateField) {
            this.selectDosageAndRateField$value = selectDosageAndRateField;
            this.selectDosageAndRateField$set = true;
            return (B)this.self();
        }

        @Generated
        public B hasMatchingComponent(BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> hasMatchingComponent) {
            this.hasMatchingComponent$value = hasMatchingComponent;
            this.hasMatchingComponent$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "FDSConfigR5.FDSConfigR5Builder(super=" + super.toString() + ", fromFHIRQuantityUnitToString$value=" + String.valueOf(this.fromFHIRQuantityUnitToString$value) + ", fromCodeableConceptToString$value=" + String.valueOf(this.fromCodeableConceptToString$value) + ", fromExtensionsToString$value=" + String.valueOf(this.fromExtensionsToString$value) + ", selectDosageAndRateField$value=" + String.valueOf(this.selectDosageAndRateField$value) + ", hasMatchingComponent$value=" + String.valueOf(this.hasMatchingComponent$value) + ")";
        }
    }

    @Generated
    private static final class FDSConfigR5BuilderImpl
    extends FDSConfigR5Builder<FDSConfigR5, FDSConfigR5BuilderImpl> {
        @Generated
        private FDSConfigR5BuilderImpl() {
        }

        @Override
        @Generated
        protected FDSConfigR5BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FDSConfigR5 build() {
            return new FDSConfigR5(this);
        }
    }
}

