/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.functions;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.QuantityToString;
import io.github.jy95.fds.common.functions.UnitsOfTimeFormatter;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.Quantity;

public class QuantityToStringR5
implements QuantityToString<FDSConfigR5, Quantity> {
    private QuantityToStringR5() {
    }

    public static QuantityToStringR5 getInstance() {
        return Holder.INSTANCE;
    }

    public boolean hasUnit(Quantity quantity) {
        return quantity.hasUnit() || quantity.hasCode();
    }

    public BigDecimal getValue(Quantity quantity) {
        return quantity.getValue();
    }

    public CompletableFuture<String> enhancedFromUnitToString(FDSConfigR5 config, Quantity quantity) {
        if (quantity.hasSystem() && quantity.hasCode() && TIME_SYSTEMS.contains(quantity.getSystem())) {
            return CompletableFuture.supplyAsync(() -> {
                String code = quantity.getCode();
                BigDecimal amount = quantity.hasValue() ? quantity.getValue() : BigDecimal.ONE;
                return UnitsOfTimeFormatter.formatWithoutCount((Locale)config.getLocale(), (String)code, (Number)amount);
            });
        }
        return config.fromFHIRQuantityUnitToString(quantity);
    }

    public CompletableFuture<String> comparatorToString(ResourceBundle bundle, FDSConfigR5 config, Quantity quantity) {
        if (quantity.hasComparator()) {
            String code = quantity.getComparator().toCode();
            String comparatorMsg = bundle.getString(code);
            String text = new MessageFormat(comparatorMsg, config.getLocale()).format((Object)new Object[0]);
            return CompletableFuture.completedFuture(text);
        }
        return CompletableFuture.completedFuture("");
    }

    private static class Holder {
        private static final QuantityToStringR5 INSTANCE = new QuantityToStringR5();

        private Holder() {
        }
    }
}

