/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.functions;

import io.github.jy95.fds.common.functions.RangeToString;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.QuantityToStringR5;
import java.math.BigDecimal;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.Range;

public class RangeToStringR5
implements RangeToString<FDSConfigR5, Range> {
    private RangeToStringR5() {
    }

    public static RangeToStringR5 getInstance() {
        return Holder.INSTANCE;
    }

    public boolean hasUnit(Range range) {
        if (this.hasHigh(range) && QuantityToStringR5.getInstance().hasUnit(range.getHigh())) {
            return true;
        }
        return this.hasLow(range) && QuantityToStringR5.getInstance().hasUnit(range.getLow());
    }

    public CompletableFuture<String> getUnitText(ResourceBundle bundle, FDSConfigR5 config, Range range, boolean hasLow, boolean hasHigh) {
        return QuantityToStringR5.getInstance().enhancedFromUnitToString(config, hasHigh ? range.getHigh() : range.getLow());
    }

    public boolean hasLow(Range range) {
        return range.hasLow();
    }

    public boolean hasHigh(Range range) {
        return range.hasHigh();
    }

    public BigDecimal getLowValue(Range range) {
        return range.getLow().getValue();
    }

    public BigDecimal getHighValue(Range range) {
        return range.getHigh().getValue();
    }

    private static class Holder {
        private static final RangeToStringR5 INSTANCE = new RangeToStringR5();

        private Holder() {
        }
    }
}

