/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.translators.AsNeeded;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.hl7.fhir.r5.model.Dosage;

public class AsNeededR5
implements AsNeeded<FDSConfigR5, Dosage> {
    protected final MessageFormat asNeededForMsg;
    protected final String asNeededMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public AsNeededR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.asNeededForMsg = this.getAsNeededForMsg(bundle, config.getLocale());
        this.asNeededMsg = this.getAsNeededMsg(bundle);
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        if (this.hasCodeableConcepts(dosage)) {
            return this.convertCodeableConcepts(dosage);
        }
        return CompletableFuture.supplyAsync(() -> this.asNeededMsg);
    }

    public boolean isPresent(Dosage dosage) {
        return dosage.hasAsNeeded() || this.hasCodeableConcepts(dosage);
    }

    public boolean hasCodeableConcepts(Dosage dosage) {
        return dosage.hasAsNeededFor();
    }

    public CompletableFuture<String> convertCodeableConcepts(Dosage dosage) {
        List codes = dosage.getAsNeededFor();
        List codesFutures = codes.stream().map(this.config::fromCodeableConceptToString).collect(Collectors.toList());
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])codesFutures.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> {
            List codesAsText = codesFutures.stream().map(future -> future.getNow("")).collect(Collectors.toList());
            return ListToString.convert((ResourceBundle)this.bundle, codesAsText);
        })).thenApplyAsync(v -> this.asNeededForMsg.format((Object)new Object[]{v}));
    }
}

