/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.BoundsDuration;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.QuantityToStringR5;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;

public class BoundsDurationR5
implements BoundsDuration<FDSConfigR5, Dosage> {
    protected final MessageFormat boundsDurationMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public BoundsDurationR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.boundsDurationMsg = this.getBoundsDurationMsg(bundle, config.getLocale());
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasBoundsDuration();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Duration boundsDuration = dosage.getTiming().getRepeat().getBoundsDuration();
        return QuantityToStringR5.getInstance().convert(this.bundle, this.config, boundsDuration).thenApplyAsync(durationText -> this.boundsDurationMsg.format((Object)new Object[]{durationText}));
    }
}

