/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.BoundsPeriod;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.FormatDateTimesR5;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Period;

public class BoundsPeriodR5
implements BoundsPeriod<FDSConfigR5, Dosage> {
    protected final MessageFormat boundsPeriodMsg;
    private final FDSConfigR5 config;

    public BoundsPeriodR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.boundsPeriodMsg = this.getBoundsPeriodMsg(bundle, config.getLocale());
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasBoundsPeriod();
    }

    public boolean hasStartPeriod(Dosage dosage) {
        return dosage.getTiming().getRepeat().getBoundsPeriod().hasStart();
    }

    public boolean hasEndPeriod(Dosage dosage) {
        return dosage.getTiming().getRepeat().getBoundsPeriod().hasEnd();
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public String formatStartPeriod(Dosage dosage) {
        Period boundPeriods = dosage.getTiming().getRepeat().getBoundsPeriod();
        Locale locale = this.config.getLocale();
        return FormatDateTimesR5.getInstance().convert(locale, boundPeriods.getStartElement());
    }

    public String formatEndPeriod(Dosage dosage) {
        Locale locale = this.config.getLocale();
        Period boundPeriods = dosage.getTiming().getRepeat().getBoundsPeriod();
        return FormatDateTimesR5.getInstance().convert(locale, boundPeriods.getEndElement());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        return CompletableFuture.supplyAsync(() -> {
            Map arguments = this.extractInformation(dosage);
            return this.boundsPeriodMsg.format((Object)arguments);
        });
    }
}

