/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.BoundsRange;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.RangeToStringR5;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Range;

public class BoundsRangeR5
implements BoundsRange<FDSConfigR5, Dosage> {
    protected final MessageFormat boundsRangeMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public BoundsRangeR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.boundsRangeMsg = this.getBoundsRangeMsg(bundle, config.getLocale());
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Range boundsRange = dosage.getTiming().getRepeat().getBoundsRange();
        return RangeToStringR5.getInstance().convert(this.bundle, this.config, boundsRange).thenApplyAsync(v -> this.boundsRangeMsg.format((Object)new Object[]{v}));
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasBoundsRange();
    }
}

