/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.common.types.Translator;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.QuantityToStringR5;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Quantity;

public class DoseQuantityR5
implements Translator<FDSConfigR5, Dosage> {
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public DoseQuantityR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        DataType doseQuantity = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.DOSE_QUANTITY);
        return QuantityToStringR5.getInstance().convert(this.bundle, this.config, (Quantity)doseQuantity);
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasDoseQuantity);
    }
}

