/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.MaxDosePerAdministration;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.QuantityToStringR5;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Quantity;

public class MaxDosePerAdministrationR5
implements MaxDosePerAdministration<FDSConfigR5, Dosage> {
    protected final MessageFormat maxDosePerAdministrationMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public MaxDosePerAdministrationR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.bundle = bundle;
        this.config = config;
        this.maxDosePerAdministrationMsg = this.getMaxDosePerAdministrationMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Quantity quantity = dosage.getMaxDosePerAdministration();
        return QuantityToStringR5.getInstance().convert(this.bundle, this.config, quantity).thenApplyAsync(quantityText -> this.maxDosePerAdministrationMsg.format((Object)new Object[]{quantityText}));
    }

    public boolean isPresent(Dosage dosage) {
        return dosage.hasMaxDosePerAdministration();
    }
}

