/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.MaxDosePerLifetime;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.QuantityToStringR5;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Quantity;

public class MaxDosePerLifetimeR5
implements MaxDosePerLifetime<FDSConfigR5, Dosage> {
    protected final MessageFormat maxDosePerLifetimeMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public MaxDosePerLifetimeR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.bundle = bundle;
        this.config = config;
        this.maxDosePerLifetimeMsg = this.getMaxDosePerLifetimeMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Quantity quantity = dosage.getMaxDosePerLifetime();
        return QuantityToStringR5.getInstance().convert(this.bundle, this.config, quantity).thenApplyAsync(quantityText -> this.maxDosePerLifetimeMsg.format((Object)new Object[]{quantityText}));
    }

    public boolean isPresent(Dosage dosage) {
        return dosage.hasMaxDosePerLifetime();
    }
}

