/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.translators.MaxDosePerPeriod;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.RatioToStringR5;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.hl7.fhir.r5.model.Dosage;

public class MaxDosePerPeriodR5
implements MaxDosePerPeriod<FDSConfigR5, Dosage> {
    protected final MessageFormat maxDosePerPeriodMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public MaxDosePerPeriodR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.bundle = bundle;
        this.config = config;
        this.maxDosePerPeriodMsg = this.getMaxDosePerPeriodMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        List ratioFutures = dosage.getMaxDosePerPeriod().stream().map(ratio -> RatioToStringR5.getInstance().convert(this.bundle, this.config, ratio)).collect(Collectors.toList());
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])ratioFutures.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> {
            List ratioTexts = ratioFutures.stream().map(future -> future.getNow("")).collect(Collectors.toList());
            return ListToString.convert((ResourceBundle)this.bundle, ratioTexts);
        })).thenApplyAsync(ratioText -> this.maxDosePerPeriodMsg.format((Object)new Object[]{ratioText}));
    }

    public boolean isPresent(Dosage dosage) {
        return dosage.hasMaxDosePerPeriod();
    }
}

