/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.functions.UnitsOfTimeFormatter;
import io.github.jy95.fds.common.translators.OffsetWhen;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Timing;

public class OffsetWhenR5
implements OffsetWhen<FDSConfigR5, Dosage> {
    private final ResourceBundle bundle;
    private final Locale locale;

    public CompletableFuture<String> convert(Dosage dosage) {
        CompletableFuture<String> offsetPart = this.turnOffsetToText(dosage);
        CompletableFuture<String> whenPart = this.turnWhenToText(dosage);
        return offsetPart.thenCombineAsync(whenPart, (offsetText, whenText) -> Stream.of(offsetText, whenText).filter(s -> !s.isEmpty()).collect(Collectors.joining(" ")));
    }

    public boolean hasRequiredElements(Dosage dosage) {
        Timing timing = dosage.getTiming();
        return timing.hasRepeat() && (timing.getRepeat().hasOffset() || timing.getRepeat().hasWhen());
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    private CompletableFuture<String> turnWhenToText(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        if (!repeat.hasWhen()) {
            return CompletableFuture.completedFuture("");
        }
        return CompletableFuture.supplyAsync(() -> {
            List events = repeat.getWhen().stream().map(Enumeration::getCode).map(this.bundle::getString).collect(Collectors.toList());
            return ListToString.convert((ResourceBundle)this.bundle, events);
        });
    }

    private CompletableFuture<String> turnOffsetToText(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        if (!repeat.hasOffset()) {
            return CompletableFuture.completedFuture("");
        }
        return this.turnOffsetValueToText(repeat.getOffset());
    }

    protected CompletableFuture<String> turnOffsetValueToText(int offset) {
        return CompletableFuture.supplyAsync(() -> {
            Map extractedTime = this.extractTime(offset);
            List times = OffsetWhen.order.stream().filter(unit -> extractedTime.getOrDefault(unit, 0) > 0).map(unit -> {
                Integer amount = (Integer)extractedTime.get(unit);
                return UnitsOfTimeFormatter.formatWithCount((Locale)this.locale, (String)unit, (Number)amount);
            }).collect(Collectors.toList());
            return ListToString.convert((ResourceBundle)this.bundle, times);
        });
    }

    @Generated
    public OffsetWhenR5(ResourceBundle bundle, Locale locale) {
        this.bundle = bundle;
        this.locale = locale;
    }
}

