/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.UnitsOfTimeFormatter;
import io.github.jy95.fds.common.translators.PeriodPeriodMax;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Timing;

public class PeriodPeriodMaxR5
implements PeriodPeriodMax<FDSConfigR5, Dosage> {
    protected final MessageFormat periodMaxMsg;
    protected final MessageFormat periodMsg;
    private final FDSConfigR5 config;

    public PeriodPeriodMaxR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.periodMaxMsg = this.getPeriodMaxMsg(bundle, config.getLocale());
        this.periodMsg = this.getPeriodMsg(bundle, config.getLocale());
    }

    public boolean hasPeriod(Dosage dosage) {
        return dosage.getTiming().getRepeat().hasPeriod();
    }

    public boolean hasPeriodMax(Dosage dosage) {
        return dosage.getTiming().getRepeat().hasPeriodMax();
    }

    public boolean hasRequiredElements(Dosage dosage) {
        Timing timing = dosage.getTiming();
        return timing.hasRepeat() && (this.hasPeriod(dosage) || this.hasPeriodMax(dosage));
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public String turnPeriodAndPeriodMaxToString(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        BigDecimal periodMax = repeat.getPeriodMax();
        BigDecimal periodMin = repeat.getPeriod();
        String periodUnit = repeat.getPeriodUnit().toCode();
        String unitText = UnitsOfTimeFormatter.formatWithoutCount((Locale)this.config.getLocale(), (String)periodUnit, (Number)periodMax);
        return this.formatPeriodAndPeriodMaxText(periodMin, periodMax, unitText);
    }

    public String turnPeriodToString(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        BigDecimal period = repeat.getPeriod();
        String periodUnit = repeat.getPeriodUnit().toCode();
        String unitText = UnitsOfTimeFormatter.formatWithoutCount((Locale)this.config.getLocale(), (String)periodUnit, (Number)period);
        return this.formatPeriodText(period, unitText);
    }

    private String formatPeriodText(BigDecimal period, String unitText) {
        Map<String, String> arguments = Map.of("period", period, "periodUnit", unitText);
        return this.periodMsg.format(arguments);
    }

    private String formatPeriodAndPeriodMaxText(BigDecimal periodMin, BigDecimal periodMax, String unitText) {
        Map<String, String> arguments = Map.of("maxPeriod", periodMax, "minPeriod", periodMin, "unit", unitText);
        return this.periodMaxMsg.format(arguments);
    }
}

