/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.RateQuantity;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.QuantityToStringR5;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Quantity;

public class RateQuantityR5
implements RateQuantity<FDSConfigR5, Dosage> {
    protected final MessageFormat rateQuantityMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public RateQuantityR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.rateQuantityMsg = this.getRateQuantityMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        DataType rateQuantity = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.RATE_QUANTITY);
        return QuantityToStringR5.getInstance().convert(this.bundle, this.config, (Quantity)rateQuantity).thenApplyAsync(rateQuantityText -> this.rateQuantityMsg.format((Object)new Object[]{rateQuantityText}));
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasRateQuantity);
    }
}

