/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.RateRange;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.functions.RangeToStringR5;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Range;

public class RateRangeR5
implements RateRange<FDSConfigR5, Dosage> {
    protected final MessageFormat rateRangeMsg;
    private final FDSConfigR5 config;
    private final ResourceBundle bundle;

    public RateRangeR5(FDSConfigR5 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.rateRangeMsg = this.getRateRangeMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        DataType rateRange = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.RATE_RANGE);
        return RangeToStringR5.getInstance().convert(this.bundle, this.config, (Range)rateRange).thenApplyAsync(rateRatioText -> this.rateRangeMsg.format((Object)new Object[]{rateRatioText}));
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasRateRange);
    }
}

