/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.utils;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.jy95.fds.common.types.DosageMarkdown;
import io.github.jy95.fds.r5.DosageAPIR5;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.MedicationRequest;

public class DosageMarkdownR5
implements DosageMarkdown<DosageAPIR5, Dosage> {
    private static final IParser JSON_PARSER = FhirContext.forR5().newJsonParser();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectNode BASE_TEMPLATE = DosageMarkdownR5.createJsonTemplate();

    public DosageAPIR5 createDosageAPI(Locale locale) {
        return new DosageAPIR5((FDSConfigR5)((FDSConfigR5.FDSConfigR5Builder)FDSConfigR5.builder().locale(locale)).build());
    }

    public List<Dosage> getDosageFromJson(Path jsonFile) throws IOException {
        String dosageJson = Files.readString(jsonFile).trim();
        JsonNode dosageNode = MAPPER.readTree(dosageJson);
        ArrayNode dosageArray = dosageNode.isArray() ? (ArrayNode)dosageNode : MAPPER.createArrayNode().add(dosageNode);
        ObjectNode workingCopy = BASE_TEMPLATE.deepCopy();
        workingCopy.set("dosageInstruction", (JsonNode)dosageArray);
        String finalJson = MAPPER.writeValueAsString((Object)workingCopy);
        MedicationRequest mr = (MedicationRequest)JSON_PARSER.parseResource(MedicationRequest.class, finalJson);
        return mr.getDosageInstruction();
    }

    private static ObjectNode createJsonTemplate() {
        ObjectNode root = MAPPER.createObjectNode();
        root.put("resourceType", "MedicationRequest");
        root.set("dosageInstruction", (JsonNode)MAPPER.createArrayNode());
        return root;
    }
}

