/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r5.utils;

import io.github.jy95.fds.common.types.AbstractTranslatorsMap;
import io.github.jy95.fds.common.types.DisplayOrder;
import io.github.jy95.fds.common.types.Translator;
import io.github.jy95.fds.r5.config.FDSConfigR5;
import io.github.jy95.fds.r5.translators.AdditionalInstructionR5;
import io.github.jy95.fds.r5.translators.AsNeededR5;
import io.github.jy95.fds.r5.translators.BoundsDurationR5;
import io.github.jy95.fds.r5.translators.BoundsPeriodR5;
import io.github.jy95.fds.r5.translators.BoundsRangeR5;
import io.github.jy95.fds.r5.translators.CountCountMaxR5;
import io.github.jy95.fds.r5.translators.DayOfWeekR5;
import io.github.jy95.fds.r5.translators.DoseQuantityR5;
import io.github.jy95.fds.r5.translators.DoseRangeR5;
import io.github.jy95.fds.r5.translators.DurationDurationMaxR5;
import io.github.jy95.fds.r5.translators.ExtensionR5;
import io.github.jy95.fds.r5.translators.FrequencyFrequencyMaxPeriodPeriodMaxR5;
import io.github.jy95.fds.r5.translators.FrequencyFrequencyMaxR5;
import io.github.jy95.fds.r5.translators.MaxDosePerAdministrationR5;
import io.github.jy95.fds.r5.translators.MaxDosePerLifetimeR5;
import io.github.jy95.fds.r5.translators.MaxDosePerPeriodR5;
import io.github.jy95.fds.r5.translators.MethodR5;
import io.github.jy95.fds.r5.translators.ModifierExtensionR5;
import io.github.jy95.fds.r5.translators.OffsetWhenR5;
import io.github.jy95.fds.r5.translators.PatientInstructionR5;
import io.github.jy95.fds.r5.translators.PeriodPeriodMaxR5;
import io.github.jy95.fds.r5.translators.RateQuantityR5;
import io.github.jy95.fds.r5.translators.RateRangeR5;
import io.github.jy95.fds.r5.translators.RateRatioR5;
import io.github.jy95.fds.r5.translators.RouteR5;
import io.github.jy95.fds.r5.translators.SiteR5;
import io.github.jy95.fds.r5.translators.TextR5;
import io.github.jy95.fds.r5.translators.TimeOfDayR5;
import io.github.jy95.fds.r5.translators.TimingCodeR5;
import io.github.jy95.fds.r5.translators.TimingEventR5;
import io.github.jy95.fds.r5.translators.TimingExtensionR5;
import io.github.jy95.fds.r5.translators.TimingModifierExtensionR5;
import io.github.jy95.fds.r5.translators.TimingRepeatExtensionR5;
import java.util.EnumMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.hl7.fhir.r5.model.Dosage;

public class TranslatorsMapR5
extends AbstractTranslatorsMap<FDSConfigR5, Dosage> {
    public TranslatorsMapR5(FDSConfigR5 config, ResourceBundle bundle) {
        super(TranslatorsMapR5.createTranslatorsSuppliers(config, bundle));
    }

    private static Map<DisplayOrder, Supplier<Translator<FDSConfigR5, Dosage>>> createTranslatorsSuppliers(FDSConfigR5 config, ResourceBundle bundle) {
        EnumMap<DisplayOrder, Supplier<Translator<FDSConfigR5, Dosage>>> suppliers = new EnumMap<DisplayOrder, Supplier<Translator<FDSConfigR5, Dosage>>>(DisplayOrder.class);
        suppliers.put(DisplayOrder.TEXT, TextR5::new);
        suppliers.put(DisplayOrder.PATIENT_INSTRUCTION, PatientInstructionR5::new);
        suppliers.put(DisplayOrder.DAY_OF_WEEK, () -> new DayOfWeekR5(config, bundle));
        suppliers.put(DisplayOrder.TIME_OF_DAY, () -> new TimeOfDayR5(config, bundle));
        suppliers.put(DisplayOrder.TIMING_CODE, () -> new TimingCodeR5(config));
        suppliers.put(DisplayOrder.TIMING_EVENT, () -> new TimingEventR5(config, bundle));
        suppliers.put(DisplayOrder.METHOD, () -> new MethodR5(config));
        suppliers.put(DisplayOrder.ROUTE, () -> new RouteR5(config));
        suppliers.put(DisplayOrder.SITE, () -> new SiteR5(config));
        suppliers.put(DisplayOrder.EXTENSION, () -> new ExtensionR5(config));
        suppliers.put(DisplayOrder.TIMING_EXTENSION, () -> new TimingExtensionR5(config));
        suppliers.put(DisplayOrder.TIMING_REPEAT_EXTENSION, () -> new TimingRepeatExtensionR5(config));
        suppliers.put(DisplayOrder.MODIFIER_EXTENSION, () -> new ModifierExtensionR5(config));
        suppliers.put(DisplayOrder.TIMING_MODIFIER_EXTENSION, () -> new TimingModifierExtensionR5(config));
        suppliers.put(DisplayOrder.ADDITIONAL_INSTRUCTION, () -> new AdditionalInstructionR5(config, bundle));
        suppliers.put(DisplayOrder.AS_NEEDED, () -> new AsNeededR5(config, bundle));
        suppliers.put(DisplayOrder.BOUNDS_PERIOD, () -> new BoundsPeriodR5(config, bundle));
        suppliers.put(DisplayOrder.BOUNDS_RANGE, () -> new BoundsRangeR5(config, bundle));
        suppliers.put(DisplayOrder.DURATION_DURATION_MAX, () -> new DurationDurationMaxR5(config, bundle));
        suppliers.put(DisplayOrder.FREQUENCY_FREQUENCY_MAX, () -> new FrequencyFrequencyMaxR5(config, bundle));
        suppliers.put(DisplayOrder.PERIOD_PERIOD_MAX, () -> new PeriodPeriodMaxR5(config, bundle));
        suppliers.put(DisplayOrder.COUNT_COUNT_MAX, () -> new CountCountMaxR5(config, bundle));
        suppliers.put(DisplayOrder.DOSE_QUANTITY, () -> new DoseQuantityR5(config, bundle));
        suppliers.put(DisplayOrder.DOSE_RANGE, () -> new DoseRangeR5(config, bundle));
        suppliers.put(DisplayOrder.RATE_QUANTITY, () -> new RateQuantityR5(config, bundle));
        suppliers.put(DisplayOrder.RATE_RANGE, () -> new RateRangeR5(config, bundle));
        suppliers.put(DisplayOrder.RATE_RATIO, () -> new RateRatioR5(config, bundle));
        suppliers.put(DisplayOrder.OFFSET_WHEN, () -> new OffsetWhenR5(bundle, config.getLocale()));
        suppliers.put(DisplayOrder.MAX_DOSE_PER_LIFETIME, () -> new MaxDosePerLifetimeR5(config, bundle));
        suppliers.put(DisplayOrder.MAX_DOSE_PER_ADMINISTRATION, () -> new MaxDosePerAdministrationR5(config, bundle));
        suppliers.put(DisplayOrder.MAX_DOSE_PER_PERIOD, () -> new MaxDosePerPeriodR5(config, bundle));
        suppliers.put(DisplayOrder.BOUNDS_DURATION, () -> new BoundsDurationR5(config, bundle));
        suppliers.put(DisplayOrder.FREQUENCY_FREQUENCY_MAX_PERIOD_PERIOD_MAX, () -> new FrequencyFrequencyMaxPeriodPeriodMaxR5((Translator<FDSConfigR5, Dosage>)((Translator)((Supplier)suppliers.get(DisplayOrder.FREQUENCY_FREQUENCY_MAX)).get()), (Translator<FDSConfigR5, Dosage>)((Translator)((Supplier)suppliers.get(DisplayOrder.PERIOD_PERIOD_MAX)).get())));
        return suppliers;
    }
}

