/*
 * Decompiled with CFR 0.152.
 */
package net.kender.Utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1 {
    private String sha1NUM;

    private SHA1(String sha) {
        this.sha1NUM = sha;
    }

    public boolean compareTo(SHA1 a) {
        return this.sha1NUM == a.sha1NUM;
    }

    public static SHA1 of(File a) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (DigestInputStream dis = new DigestInputStream(new FileInputStream(a.getAbsolutePath()), md);){
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
        }
        byte[] hash = md.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return new SHA1(hexString.toString());
    }

    public static SHA1 of(String sha) {
        return new SHA1(sha);
    }
}

