/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.al;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.k3nder.al.buffers.ALBuffer;
import net.k3nder.utils.UBuffer;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.libc.LibCStdlib;

public class ALSound {
    private final ALBuffer buffer = new ALBuffer();

    private ALSound(ShortBuffer buffer, int format, int sampleRate) {
        this.buffer.uploadData(format, buffer, sampleRate);
        LibCStdlib.free((ShortBuffer)buffer);
    }

    public static ALSound create(InputStream stream) throws IOException {
        MemoryStack.stackPush();
        IntBuffer channelsBuffer = MemoryStack.stackMallocInt((int)1);
        MemoryStack.stackPush();
        IntBuffer sampleRateBuffer = MemoryStack.stackMallocInt((int)1);
        ShortBuffer rawAudioBuffer = STBVorbis.stb_vorbis_decode_memory((ByteBuffer)UBuffer.streamToByteBuffer(stream), (IntBuffer)channelsBuffer, (IntBuffer)sampleRateBuffer);
        int channels = channelsBuffer.get();
        int sampleRate = sampleRateBuffer.get();
        MemoryStack.stackPop();
        MemoryStack.stackPop();
        int format = -1;
        if (channels == 1) {
            format = 4353;
        } else if (channels == 2) {
            format = 4355;
        }
        return new ALSound(rawAudioBuffer, format, sampleRate);
    }

    public static ALSound create(File file) throws IOException {
        return ALSound.create(file);
    }

    public static ALSound create(String file) throws IOException {
        return ALSound.create(new FileInputStream(file));
    }

    public ALBuffer buffer() {
        return this.buffer;
    }
}

