/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl;

import java.nio.IntBuffer;
import net.k3nder.gl.Initializable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL11;

public abstract class Window
implements Initializable {
    protected Long id;
    private boolean disableControls;

    public Window(String title, int width, int height) {
        this.id = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)0L, (long)0L);
        if (this.id == 0L) {
            throw new IllegalStateException("Unable to create GLFW window");
        }
        this.window();
        this.show();
    }

    public Window(String title) {
        long primaryMotor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
        this.id = GLFW.glfwCreateWindow((int)vidmode.width(), (int)vidmode.height(), (CharSequence)title, (long)primaryMotor, (long)0L);
        if (this.id == 0L) {
            throw new IllegalStateException("Unable to create GLFW window");
        }
        this.window();
        this.show();
    }

    public Window(String title, long primaryMotor) {
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)primaryMotor);
        this.id = GLFW.glfwCreateWindow((int)vidmode.width(), (int)vidmode.height(), (CharSequence)title, (long)primaryMotor, (long)0L);
        if (this.id == 0L) {
            throw new IllegalStateException("Unable to create GLFW window");
        }
        this.window();
        this.show();
    }

    public Window(String title, long primaryMotor, GLFWVidMode vidmode) {
        this.id = GLFW.glfwCreateWindow((int)vidmode.width(), (int)vidmode.height(), (CharSequence)title, (long)primaryMotor, (long)0L);
        if (this.id == 0L) {
            throw new IllegalStateException("Unable to create GLFW window");
        }
        this.window();
        GLFW.glfwShowWindow((long)this.id);
    }

    @Override
    public void init() {
        while (!GLFW.glfwWindowShouldClose((long)this.id)) {
            this.loop();
        }
        this.cleanup();
        GLFW.glfwTerminate();
    }

    private void loop() {
        if (!this.disableControls) {
            this.ControlsCallback();
        }
        this.draw();
        GLFW.glfwSwapBuffers((long)this.id);
        GLFW.glfwPollEvents();
    }

    public void draw() {
    }

    public void window() {
        GLFW.glfwMakeContextCurrent((long)this.id);
        GLFW.glfwSetFramebufferSizeCallback((long)this.id, this::BufferSizeCallback);
        GLFW.glfwSetCursorPosCallback((long)this.id, this::MousePosCallback);
        GLFW.glfwSetScrollCallback((long)this.id, this::MouseScrollCallback);
        GLFW.glfwSetMouseButtonCallback((long)this.id, this::MouseClickCallback);
        GLFW.glfwSetKeyCallback((long)this.id, this::KeyCallback);
        GLFW.glfwSetCharCallback((long)this.id, this::CharCallback);
        GLFW.glfwSetWindowRefreshCallback((long)this.id, this::RefreshCallback);
        GLFW.glfwSetWindowCloseCallback((long)this.id, this::CloseCallback);
        GLFW.glfwSetWindowFocusCallback((long)this.id, this::FocusCallback);
    }

    public void KeyCallback(long id, int key, int scancode, int action, int mods) {
    }

    public void MousePosCallback(long id, double x, double y) {
    }

    public void MouseClickCallback(long id, int button, int action, int mods) {
    }

    public void MouseScrollCallback(long id, double x, double y) {
    }

    public void RefreshCallback(long id) {
    }

    public void CloseCallback(long id) {
    }

    public void FocusCallback(long id, boolean focus) {
    }

    public void GLFWSetup() {
        GLFW.glfwDefaultWindowHints();
    }

    public void cleanup() {
    }

    protected void BufferSizeCallback(long window, int width, int height) {
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    public void ControlsCallback() {
    }

    public void CharCallback(long id, int character) {
    }

    public final void close() {
        GLFW.glfwSetWindowShouldClose((long)this.id, (boolean)true);
    }

    public final void hide() {
        GLFW.glfwHideWindow((long)this.id);
    }

    public final void show() {
        GLFW.glfwShowWindow((long)this.id);
    }

    public final void destroy() {
        GLFW.glfwDestroyWindow((long)this.id);
    }

    public void disableControls() {
        this.disableControls = true;
    }

    public void enableControls() {
        this.disableControls = false;
    }

    public void disableKey() {
        GLFW.glfwSetKeyCallback((long)this.id, null);
    }

    public void enableKey() {
        GLFW.glfwSetKeyCallback((long)this.id, this::KeyCallback);
    }

    public void disableChar() {
        GLFW.glfwSetCharCallback((long)this.id, null);
    }

    public void enableChar() {
        GLFW.glfwSetCharCallback((long)this.id, this::CharCallback);
    }

    public void disableMousePos() {
        GLFW.glfwSetCursorPosCallback((long)this.id, null);
    }

    public void enableMousePos() {
        GLFW.glfwSetCursorPosCallback((long)this.id, this::MousePosCallback);
    }

    public void disableMouseScroll() {
        GLFW.glfwSetScrollCallback((long)this.id, null);
    }

    public void enableMouseScroll() {
        GLFW.glfwSetScrollCallback((long)this.id, this::MouseScrollCallback);
    }

    public void disableMouseClick() {
        GLFW.glfwSetMouseButtonCallback((long)this.id, null);
    }

    public void enableMouseClick() {
        GLFW.glfwSetMouseButtonCallback((long)this.id, this::MouseClickCallback);
    }

    public final void fullscreen() {
        long motor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)motor);
        GLFW.glfwSetWindowMonitor((long)this.id, (long)motor, (int)0, (int)0, (int)vidmode.width(), (int)vidmode.height(), (int)-1);
    }

    public final void windowed() {
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
        GLFW.glfwSetWindowMonitor((long)this.id, (long)0L, (int)((vidMode.width() - this.width()) / 2), (int)((vidMode.height() - this.height()) / 2), (int)this.width(), (int)this.height(), (int)-1);
    }

    public final int width() {
        int[] width = new int[1];
        int[] height = new int[1];
        GLFW.glfwGetWindowSize((long)this.id, (int[])width, (int[])height);
        return width[0];
    }

    public final int height() {
        int[] height = new int[1];
        int[] width = new int[1];
        GLFW.glfwGetWindowSize((long)this.id, (int[])width, (int[])height);
        return height[0];
    }

    public final void setWindowPos(int x, int y) {
        GLFW.glfwSetWindowPos((long)this.id, (int)x, (int)y);
    }

    public final void setWindowSize(int width, int height) {
        GLFW.glfwSetWindowSize((long)this.id, (int)width, (int)height);
    }

    public final void setWindowSizeLimits(int width, int height) {
        GLFW.glfwSetWindowSizeLimits((long)this.id, (int)width, (int)height, (int)this.width(), (int)this.height());
    }

    public final void setWindowAspectRatio(int width, int height) {
        GLFW.glfwSetWindowAspectRatio((long)this.id, (int)width, (int)height);
    }

    public final void setWindowMonitor(long monitor, int xpos, int ypox, int width, int height, int refreshRate) {
        GLFW.glfwSetWindowMonitor((long)this.id, (long)monitor, (int)xpos, (int)ypox, (int)width, (int)height, (int)refreshRate);
    }

    public final long getWindowMonitor() {
        return GLFW.glfwGetWindowMonitor((long)this.id);
    }

    public final void getFramebufferSize(IntBuffer width, IntBuffer height) {
        GLFW.glfwGetFramebufferSize((long)this.id, (IntBuffer)width, (IntBuffer)height);
    }

    public final void setTitle(String title) {
        GLFW.glfwSetWindowTitle((long)this.id, (CharSequence)title);
    }

    public final void setIcon(GLFWImage.Buffer icon) {
        GLFW.glfwSetWindowIcon((long)this.id, (GLFWImage.Buffer)icon);
    }

    public final void setOpacity(float opacity) {
        GLFW.glfwSetWindowOpacity((long)this.id, (float)opacity);
    }

    public final void setUserPointer(long userPointer) {
        GLFW.glfwSetWindowUserPointer((long)this.id, (long)userPointer);
    }

    public final long getUserPointer() {
        return GLFW.glfwGetWindowUserPointer((long)this.id);
    }

    public final void getPos(IntBuffer w, IntBuffer h) {
        GLFW.glfwGetWindowPos((long)this.id, (IntBuffer)w, (IntBuffer)h);
    }

    public final void getSize(IntBuffer w, IntBuffer h) {
        GLFW.glfwGetWindowSize((long)this.id, (IntBuffer)w, (IntBuffer)h);
    }

    public final void minimize() {
        GLFW.glfwIconifyWindow((long)this.id);
    }

    public final void restore() {
        GLFW.glfwRestoreWindow((long)this.id);
    }

    public final void swapInterval(int interval) {
        GLFW.glfwSwapInterval((int)interval);
    }

    public final void makeContextCurrent() {
        GLFW.glfwMakeContextCurrent((long)this.id);
    }
}

