/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl.graphic;

import net.k3nder.gl.Camera;
import net.k3nder.gl.Reloadable;
import net.k3nder.gl.Renderable;
import net.k3nder.gl.graphic.model.Polygon;
import net.k3nder.gl.graphic.shader.Shader;
import net.k3nder.gl.graphic.visual.Texture;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL13;

public abstract class GraphicalObject
implements Renderable<Shader>,
Reloadable {
    protected Polygon polygon;
    protected Texture texture;
    protected Matrix4f model = new Matrix4f();
    protected Boolean selected;
    private boolean lastSelected;

    @Override
    public void render(Shader shader) {
        shader.use();
        GL13.glActiveTexture((int)33984);
        this.texture.bind();
        shader.setI("tex", this.texture.getID());
        shader.setMatrix(this.model, "model");
        this.polygon.render(4);
    }

    @Override
    public void clean() {
        this.polygon.clean();
    }

    @Override
    public void load() {
        this.polygon.load();
    }

    public Vector3f[] getTransformedVertices() {
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-0.5f, -0.5f, -0.5f), new Vector3f(0.5f, -0.5f, -0.5f), new Vector3f(0.5f, 0.5f, -0.5f), new Vector3f(-0.5f, 0.5f, -0.5f), new Vector3f(-0.5f, -0.5f, 0.5f), new Vector3f(0.5f, -0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(-0.5f, 0.5f, 0.5f)};
        Vector3f[] transformedVertices = new Vector3f[8];
        for (int i = 0; i < 8; ++i) {
            transformedVertices[i] = vertices[i].mulPosition((Matrix4fc)this.model, new Vector3f());
        }
        return transformedVertices;
    }

    public Vector3f getMin() {
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY);
        for (Vector3f v : this.getTransformedVertices()) {
            min.min((Vector3fc)v);
        }
        return min;
    }

    public Vector3f getMax() {
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY);
        for (Vector3f v : this.getTransformedVertices()) {
            max.max((Vector3fc)v);
        }
        return max;
    }

    public void checkCameraPointer(Camera camera) {
        if (camera.check(this, 100.0f)) {
            if (!this.lastSelected) {
                this.selected = true;
                this.lastSelected = true;
                this.Selected();
            }
        } else {
            this.selected = false;
            if (this.lastSelected) {
                this.Unselected();
                this.lastSelected = false;
            }
        }
    }

    public void Selected() {
    }

    public void Unselected() {
    }

    public void Clicked() {
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public GraphicalObject setSelected(Boolean selected) {
        this.selected = selected;
        return this;
    }

    public Matrix4f getModel() {
        return this.model;
    }

    public GraphicalObject setModel(Matrix4f model) {
        this.model = model;
        return this;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public GraphicalObject setTexture(Texture texture) {
        this.texture = texture;
        return this;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public GraphicalObject setPolygon(Polygon polygon) {
        this.polygon = polygon;
        return this;
    }
}

