/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl.graphic.model;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.k3nder.gl.Reloadable;
import net.k3nder.gl.graphic.model.AttribPointers;
import net.k3nder.gl.graphic.model.ElementArrayBuffer;
import net.k3nder.gl.graphic.model.VertexArrayObject;
import net.k3nder.gl.graphic.model.VertexBufferObject;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

public class Polygon
implements Reloadable {
    private VertexArrayObject VAO;
    private VertexBufferObject VBO;
    private ElementArrayBuffer EBO;
    private FloatBuffer vertices;
    private IntBuffer indices;
    private AttribPointers attribs;
    private int numVertices;

    public FloatBuffer getVertices() {
        return this.vertices;
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public void setNumVertices(int numVertices) {
        this.numVertices = numVertices;
    }

    public void use() {
        this.VAO.bind();
        this.EBO.bind();
        this.attribs.enable();
    }

    public void unuse() {
        this.attribs.disable();
        GL30.glBindVertexArray((int)0);
    }

    public void render(Integer mode) {
        this.use();
        GL30.glDrawElements((int)mode, (int)this.vertices.limit(), (int)5125, (long)0L);
        this.unuse();
    }

    @Override
    public void load() {
        this.load(35044);
    }

    public void load(Integer mode) {
        this.VAO = new VertexArrayObject();
        this.VAO.bind();
        this.vertices.flip();
        this.indices.flip();
        this.VBO = new VertexBufferObject();
        this.VBO.bind(34962);
        this.VBO.uploadData(34962, this.vertices, (int)mode);
        this.EBO = new ElementArrayBuffer();
        this.EBO.bind();
        this.EBO.uploadData(34963, this.indices, (int)mode);
        this.attribs.apply();
        this.attribs.enable();
        GL30.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void clean() {
        this.VAO.delete();
        this.VBO.delete();
        this.EBO.delete();
    }

    public static class Builder {
        private final FloatBuffer vertices = MemoryUtil.memAllocFloat((int)4096);
        private final AttribPointers attribs;
        private final IntBuffer indices = MemoryUtil.memAllocInt((int)4096);

        public Builder() {
            this.attribs = new AttribPointers();
        }

        public Builder put(float x) {
            this.vertices.put(x);
            return this;
        }

        public Builder attribPointer(int lay, int size) {
            this.attribs.add(lay, size);
            return this;
        }

        public Builder face(int face) {
            this.indices.put(face);
            return this;
        }

        public Polygon build() {
            Polygon polygon = new Polygon();
            polygon.attribs = this.attribs;
            polygon.vertices = this.vertices;
            polygon.indices = this.indices;
            return polygon;
        }
    }
}

