/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl.graphic.shader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import net.k3nder.gl.exceptions.ShaderCompilationException;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryStack;

public class Shader {
    private int fragmentShaderId;
    private int vertexShaderId;
    private int programId;
    public static final String SIMPLE_VERTEX_SHADER = "        #version 330 core\n        layout (location = 0) in vec3 aPos;\n        layout (location = 1) in vec2 aTexCoord;\n        uniform mat4 model;\n        uniform mat4 view;\n        uniform mat4 projection;\n        out vec2 TexCoord;\n        void main()\n        {\n           gl_Position = projection * view * model * vec4(aPos, 1.0);\n           TexCoord = aTexCoord;\n        }\n";
    public static final String SIMPLE_FRAGMENT_SHADER = "        #version 330 core\n        out vec4 FragColor;\n        in vec2 TexCord;\n        uniform sampler2D tex;\n        void main()\n        {\n           FragColor = texture(tex, TexCord);\n        }\n";

    private Shader() {
    }

    public static Shader create() {
        return Shader.create(SIMPLE_VERTEX_SHADER, SIMPLE_FRAGMENT_SHADER);
    }

    public static Shader create(File vertexFile, File fragmentFile) throws IOException {
        FileInputStream vertexFis = new FileInputStream(vertexFile);
        FileInputStream fragmentFis = new FileInputStream(fragmentFile);
        return Shader.create(vertexFis, fragmentFis);
    }

    public static Shader create(InputStream vertexShader, InputStream fragmentShader) throws IOException {
        String vertexS = new String(vertexShader.readAllBytes());
        String fragmentS = new String(fragmentShader.readAllBytes());
        return Shader.create(vertexS, fragmentS);
    }

    public static Shader create(String vertex, String fragment) {
        int vertexId = Shader.compileShader(35633, vertex);
        int fragmentId = Shader.compileShader(35632, fragment);
        return Shader.create(vertexId, fragmentId);
    }

    public static Shader create(int vertexShader, int fragmentShader) {
        Shader sh = new Shader();
        int shader = GL20.glCreateProgram();
        GL20.glAttachShader((int)shader, (int)vertexShader);
        GL20.glAttachShader((int)shader, (int)fragmentShader);
        GL20.glLinkProgram((int)shader);
        Shader.checkCompileErrors(shader, "PROGRAM");
        sh.setFragmentShaderId(fragmentShader);
        sh.setVertexShaderId(vertexShader);
        sh.setProgramId(shader);
        GL20.glDeleteShader((int)vertexShader);
        GL20.glDeleteShader((int)fragmentShader);
        return sh;
    }

    public static int compileShader(int type, String source) {
        int id = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)id, (CharSequence)source);
        GL20.glCompileShader((int)id);
        Shader.checkCompileErrors(id, type == 35633 ? "VERTEX" : "FRAGMENT");
        return id;
    }

    public static void checkCompileErrors(int shader, String type) {
        if (type.equals("PROGRAM")) {
            int success = GL20.glGetProgrami((int)shader, (int)35714);
            if (success == 0) {
                String infoLog = GL20.glGetProgramInfoLog((int)shader);
                throw new ShaderCompilationException("ERROR::SHADER::PROGRAM::LINKING_FAILED\n" + infoLog);
            }
        } else {
            int success = GL20.glGetShaderi((int)shader, (int)35713);
            if (success == 0) {
                String infoLog = GL20.glGetShaderInfoLog((int)shader);
                throw new ShaderCompilationException("ERROR::SHADER::" + type + "::COMPILATION_FAILED\n" + infoLog);
            }
        }
    }

    public void use() {
        GL20.glUseProgram((int)this.programId);
    }

    public int getVertexShaderId() {
        return this.vertexShaderId;
    }

    public void setVertexShaderId(int vertexShaderId) {
        this.vertexShaderId = vertexShaderId;
    }

    public int getProgramId() {
        return this.programId;
    }

    public void setProgramId(int programId) {
        this.programId = programId;
    }

    public int getFragmentShaderId() {
        return this.fragmentShaderId;
    }

    public void setFragmentShaderId(int fragmentShaderId) {
        this.fragmentShaderId = fragmentShaderId;
    }

    public void setFloat(String name, float value) {
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (float)value);
    }

    public void setI(String name, float value) {
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (float)value);
    }

    public void setV4f(String name, float x, float y, float z, float w) {
        GL20.glUniform4f((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (float)x, (float)y, (float)z, (float)w);
    }

    public void setVec3(String name, Vector3f value) {
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (float)value.x, (float)value.y, (float)value.z);
    }

    public void setV2f(String name, Vector2f value) {
        GL20.glUniform2f((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (float)value.x, (float)value.y);
    }

    public void setMatrix(Matrix4f matrix, String key) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer transformBuffer = stack.mallocFloat(16);
            matrix.get(transformBuffer);
            int transformLoc = GL20.glGetUniformLocation((int)this.programId, (CharSequence)key);
            GL20.glUniformMatrix4fv((int)transformLoc, (boolean)false, (FloatBuffer)transformBuffer);
        }
    }
}

