/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl.graphic.visual;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public class Texture {
    private final int id = GL11.glGenTextures();
    private int width;
    private int height;

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.id);
    }

    public void setParameter(int param, int value) {
        GL11.glTexParameteri((int)3553, (int)param, (int)value);
    }

    public void uploadData(int width, int height, ByteBuffer data) {
        this.uploadData(32856, width, height, 6408, data);
    }

    public void uploadData(int internalFormat, int width, int height, int format, ByteBuffer data) {
        GL11.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)5121, (ByteBuffer)data);
    }

    public void delete() {
        GL11.glDeleteTextures((int)this.id);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        if (width > 0) {
            this.width = width;
        }
    }

    public void setHeight(int height) {
        if (height > 0) {
            this.height = height;
        }
    }

    public static Texture createTexture(int width, int height, ByteBuffer data) {
        Texture tex = new Texture();
        tex.setWidth(width);
        tex.setHeight(height);
        tex.bind();
        tex.setParameter(10242, 33069);
        tex.setParameter(10243, 33069);
        tex.setParameter(10241, 9728);
        tex.setParameter(10240, 9728);
        tex.uploadData(32856, width, height, 6408, data);
        return tex;
    }

    public static Texture loadTexture(String path) {
        int height;
        int width;
        ByteBuffer image;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            IntBuffer h = stack.mallocInt(1);
            IntBuffer comp = stack.mallocInt(1);
            STBImage.stbi_set_flip_vertically_on_load((boolean)true);
            image = STBImage.stbi_load((CharSequence)path, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)4);
            if (image == null) {
                throw new RuntimeException("Failed to load a texture file!" + System.lineSeparator() + STBImage.stbi_failure_reason());
            }
            width = w.get();
            height = h.get();
        }
        return Texture.createTexture(width, height, image);
    }

    public int getID() {
        return this.id;
    }
}

