/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gravity;

import java.util.ArrayList;
import java.util.List;
import net.k3nder.gravity.AABB;

public class SpatialGrid {
    private final int gridSize;
    private final List<AABB>[][][] grid;
    private final int gridCount;
    private final int halfGridCount;

    public SpatialGrid(int gridSize, int worldSize) {
        this.gridSize = gridSize;
        this.gridCount = worldSize / gridSize;
        this.halfGridCount = this.gridCount / 2;
        this.grid = new ArrayList[this.gridCount][this.gridCount][this.gridCount];
        for (int x = 0; x < this.gridCount; ++x) {
            for (int y = 0; y < this.gridCount; ++y) {
                for (int z = 0; z < this.gridCount; ++z) {
                    this.grid[x][y][z] = new ArrayList<AABB>();
                }
            }
        }
    }

    private int getGridIndex(float coord) {
        int index = (int)Math.floor(coord / (float)this.gridSize) + this.halfGridCount;
        if (index < 0) {
            index = 0;
        } else if (index >= this.gridCount) {
            index = this.gridCount - 1;
        }
        return index;
    }

    public void add(AABB box) {
        int minX = this.getGridIndex(box.getMin().x);
        int minY = this.getGridIndex(box.getMin().y);
        int minZ = this.getGridIndex(box.getMin().z);
        int maxX = this.getGridIndex(box.getMax().x);
        int maxY = this.getGridIndex(box.getMax().y);
        int maxZ = this.getGridIndex(box.getMax().z);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.grid[x][y][z].add(box);
                }
            }
        }
    }

    public List<AABB> getNearbyBoxes(AABB box) {
        int minX = this.getGridIndex(box.getMin().x);
        int minY = this.getGridIndex(box.getMin().y);
        int minZ = this.getGridIndex(box.getMin().z);
        int maxX = this.getGridIndex(box.getMax().x);
        int maxY = this.getGridIndex(box.getMax().y);
        int maxZ = this.getGridIndex(box.getMax().z);
        ArrayList<AABB> nearbyBoxes = new ArrayList<AABB>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    nearbyBoxes.addAll(this.grid[x][y][z]);
                }
            }
        }
        return nearbyBoxes;
    }
}

