/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;

public class UBuffer {
    private UBuffer() {
        throw new IllegalStateException("Utility class");
    }

    public static String[] splitBuffer(StringBuffer line) {
        return line.toString().split("\\s+");
    }

    public static boolean streamStartsWith(StringBuffer stream, String prefix) {
        String s = stream.toString();
        return s.startsWith(prefix);
    }

    public static List<StringBuffer> splitInputStreamByLine(InputStream inputStream) throws IOException {
        String line;
        ArrayList<StringBuffer> buffers = new ArrayList<StringBuffer>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            StringBuffer buffer = new StringBuffer(line);
            buffers.add(buffer);
        }
        return buffers;
    }

    public static ByteBuffer streamToByteBuffer(InputStream stream, int bufferSize) throws IOException {
        ByteBuffer buffer;
        try (InputStream source = stream;
             ReadableByteChannel rbc = Channels.newChannel(source);){
            int bytes;
            buffer = ByteBuffer.allocateDirect(bufferSize);
            while ((bytes = rbc.read(buffer)) != -1) {
                if (buffer.remaining() != 0) continue;
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(buffer.capacity() * 2);
                buffer.flip();
                newBuffer.put(buffer);
                buffer = newBuffer;
            }
            buffer.flip();
        }
        return buffer;
    }

    public static ByteBuffer streamToByteBuffer(InputStream stream) throws IOException {
        return UBuffer.streamToByteBuffer(stream, 1024);
    }
}

