/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl;

import java.util.List;
import net.k3nder.gl.Applicable;
import net.k3nder.gl.graphic.GraphicalObject;
import net.k3nder.gl.graphic.shader.Shader;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Camera
implements Applicable<Shader> {
    private Vector3f cameraPos = new Vector3f(0.0f, 0.0f, -3.0f);
    private Vector3f cameraFront = new Vector3f(1.0f, 0.0f, 0.0f);
    private Vector3f cameraUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f cameraRight = new Vector3f(0.0f, 0.0f, 0.0f);
    private float lastX;
    private float lastY;
    private float yaw = -90.0f;
    private float pitch = 0.0f;
    private float roll = 0.0f;
    public float MovementSpeed = 10.0f;
    public float MouseSensitivity = 1.0f;
    public float Zoom;
    private int width;
    private int height;
    private float fov = 45.0f;

    private Camera() {
    }

    public static Camera create(int width, int height) {
        Camera camera = new Camera();
        camera.width = width;
        camera.height = height;
        camera.lastX = (float)width / 2.0f;
        camera.lastY = (float)height / 2.0f;
        return camera;
    }

    public void setPos(float x, float y, float z) {
        this.cameraPos.set(x, y, z);
    }

    public void addPos(float x, float y, float z) {
        this.cameraPos.add(x, y, z);
    }

    public void move(Direction direction, float deltaTime) {
        this.cameraPos = this.calcNewPosToMove(deltaTime, direction);
    }

    public void setFov(float fov) {
        this.fov = fov;
    }

    public void updateRotation() {
        Vector3f direction = new Vector3f();
        direction.x = (float)(Math.cos(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)));
        direction.y = (float)Math.sin(Math.toRadians(this.pitch));
        direction.z = (float)(Math.sin(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)));
        this.cameraFront = new Vector3f((Vector3fc)direction).normalize();
    }

    public void rotate(double xpos, double ypos) {
        float xoffset = (float)(xpos - (double)this.lastX);
        float yoffset = (float)((double)this.lastY - ypos);
        this.lastX = (float)xpos;
        this.lastY = (float)ypos;
        float sensitivity = 0.1f;
        this.yaw += (xoffset *= sensitivity);
        this.pitch += (yoffset *= sensitivity);
    }

    public void rotateX(float angle) {
        this.pitch += angle;
    }

    public void rotateY(float angle) {
        this.roll += angle;
    }

    public void rotateZ(float angle) {
        this.yaw += angle;
    }

    public Matrix4f getView() {
        return new Matrix4f().lookAt((Vector3fc)this.cameraPos, (Vector3fc)this.cameraPos.add((Vector3fc)this.cameraFront, new Vector3f()), (Vector3fc)this.cameraUp);
    }

    public Matrix4f getProjection() {
        Matrix4f projection = new Matrix4f().identity();
        projection.perspective((float)Math.toRadians(this.fov), (float)this.width / (float)this.height, 0.1f, 100.0f);
        return projection;
    }

    @Override
    public void apply(Shader shader) {
        shader.setMatrix(this.getView(), "view");
        shader.setMatrix(this.getProjection(), "projection");
        shader.setVec3("viewPos", this.cameraPos);
    }

    public void setLastX(float x) {
        this.lastX = x;
    }

    public void setLastY(float y) {
        this.lastY = y;
    }

    public Vector3f getPos() {
        return new Vector3f((Vector3fc)this.cameraPos);
    }

    public Vector3f calcNewPosToMove(float deltaTime, Direction direction) {
        float velocity = this.MovementSpeed * deltaTime;
        Vector3f cameraPos = null;
        try {
            cameraPos = (Vector3f)this.getPos().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (direction == Direction.FRONT) {
            cameraPos.add((Vector3fc)this.cameraFront.mul(velocity, new Vector3f()));
        } else if (direction == Direction.BACK) {
            cameraPos.sub((Vector3fc)this.cameraFront.mul(velocity, new Vector3f()));
        } else if (direction == Direction.LEFT) {
            Vector3f right = new Vector3f((Vector3fc)this.cameraFront).cross((Vector3fc)this.cameraUp).normalize();
            cameraPos.sub((Vector3fc)right.mul(velocity));
        } else if (direction == Direction.RIGHT) {
            Vector3f right = new Vector3f((Vector3fc)this.cameraFront).cross((Vector3fc)this.cameraUp).normalize();
            cameraPos.add((Vector3fc)right.mul(velocity));
        } else if (direction == Direction.UP) {
            cameraPos.add((Vector3fc)new Vector3f((Vector3fc)this.cameraUp).mul(velocity));
        } else if (direction == Direction.DOWN) {
            cameraPos.sub((Vector3fc)new Vector3f((Vector3fc)this.cameraUp).mul(velocity));
        }
        return cameraPos;
    }

    public Vector3f getCameraFront() {
        return new Vector3f((Vector3fc)this.cameraFront);
    }

    public boolean check(GraphicalObject modelMatrix) {
        Vector3f objectPos = new Vector3f();
        modelMatrix.getModel().getTranslation(objectPos);
        Vector3f cameraDir = this.getCameraFront();
        Vector3f objectDir = new Vector3f();
        objectPos.sub((Vector3fc)this.cameraPos, objectDir);
        objectDir.normalize();
        cameraDir.normalize();
        float cosTheta = cameraDir.dot((Vector3fc)objectDir);
        float cosThetaMax = (float)Math.cos(Math.toRadians(this.fov / 2.0f));
        return cosTheta >= cosThetaMax;
    }

    public <T extends GraphicalObject> int checks(List<T> objects, float maxDistance) {
        int closestIndex = -1;
        float closestTmin = Float.MAX_VALUE;
        for (int i = 0; i < objects.size(); ++i) {
            Vector3f rayDirection;
            Vector3f cameraPos;
            float tmin;
            GraphicalObject object = (GraphicalObject)objects.get(i);
            if (!this.check(object) || !((tmin = Camera.getTmin(object, cameraPos = new Vector3f((Vector3fc)this.cameraPos), rayDirection = new Vector3f((Vector3fc)this.cameraFront).normalize())) < closestTmin) || !(tmin >= 0.0f)) continue;
            closestTmin = tmin;
            closestIndex = i;
        }
        return closestIndex;
    }

    private static float getTmin(GraphicalObject object, Vector3f cameraPos, Vector3f rayDirection) {
        float tmaxZ;
        float tminZ;
        float tmaxY;
        float tminY;
        Vector3f max = object.getMax();
        Vector3f min = object.getMin();
        float tminX = (min.x - cameraPos.x) / rayDirection.x;
        float tmaxX = (max.x - cameraPos.x) / rayDirection.x;
        if (tminX > tmaxX) {
            float temp = tminX;
            tminX = tmaxX;
            tmaxX = temp;
        }
        if ((tminY = (min.y - cameraPos.y) / rayDirection.y) > (tmaxY = (max.y - cameraPos.y) / rayDirection.y)) {
            float temp = tminY;
            tminY = tmaxY;
            tmaxY = temp;
        }
        if ((tminZ = (min.z - cameraPos.z) / rayDirection.z) > (tmaxZ = (max.z - cameraPos.z) / rayDirection.z)) {
            float temp = tminZ;
            tminZ = tmaxZ;
            tmaxZ = temp;
        }
        float tmin = Math.max(tminX, Math.max(tminY, tminZ));
        return tmin;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public static enum Direction {
        FRONT,
        BACK,
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

