/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl.graphic.model;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.k3nder.gl.Loader;
import net.k3nder.gl.exceptions.LoadModelException;
import net.k3nder.gl.graphic.model.Polygon;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.assimp.Assimp;

public class ModelLoader
implements Loader<Polygon> {
    @Override
    public Polygon load(InputStream s) {
        try {
            Path tmpfile = Files.createTempFile("model-", "-loader", new FileAttribute[0]);
            FileWriter writer = new FileWriter(tmpfile.toFile());
            writer.write(new String(s.readAllBytes()));
            writer.close();
            tmpfile.toFile().deleteOnExit();
            return this.load(tmpfile.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Polygon load(File file) {
        int i;
        Polygon.Builder builder = new Polygon.Builder();
        AIScene scene = Assimp.aiImportFile((CharSequence)file.getAbsolutePath(), (int)10);
        if (scene == null) {
            throw new LoadModelException();
        }
        AIMesh mesh = AIMesh.create((long)scene.mMeshes().get(0));
        AIVector3D.Buffer vertexBuffer = mesh.mVertices();
        AIVector3D.Buffer normalBuffer = mesh.mNormals();
        AIVector3D.Buffer texCoordBuffer = mesh.mTextureCoords(0);
        if (texCoordBuffer != null) {
            for (i = 0; i < mesh.mNumVertices(); ++i) {
                builder.put(((AIVector3D)vertexBuffer.get(i)).x());
                builder.put(((AIVector3D)vertexBuffer.get(i)).y());
                builder.put(((AIVector3D)vertexBuffer.get(i)).z());
                builder.put(((AIVector3D)normalBuffer.get(i)).x());
                builder.put(((AIVector3D)normalBuffer.get(i)).y());
                builder.put(((AIVector3D)normalBuffer.get(i)).z());
                builder.put(((AIVector3D)texCoordBuffer.get(i)).x());
                builder.put(((AIVector3D)texCoordBuffer.get(i)).y());
            }
        } else {
            for (i = 0; i < mesh.mNumVertices(); ++i) {
                builder.put(((AIVector3D)vertexBuffer.get(i)).x());
                builder.put(((AIVector3D)vertexBuffer.get(i)).y());
                builder.put(((AIVector3D)vertexBuffer.get(i)).z());
                builder.put(((AIVector3D)normalBuffer.get(i)).x());
                builder.put(((AIVector3D)normalBuffer.get(i)).y());
                builder.put(((AIVector3D)normalBuffer.get(i)).z());
                builder.put(0.0f);
                builder.put(0.0f);
            }
        }
        for (i = 0; i < mesh.mNumFaces(); ++i) {
            IntBuffer indexBuffer = ((AIFace)mesh.mFaces().get(i)).mIndices();
            while (indexBuffer.remaining() > 0) {
                builder.face(indexBuffer.get());
            }
        }
        builder.attribPointer(0, 3);
        builder.attribPointer(1, 3);
        builder.attribPointer(2, 2);
        return builder.build();
    }
}

