/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gl.graphic.text;

import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.k3nder.gl.graphic.visual.Texture;

public class Font {
    private java.awt.Font font;
    private HashMap<Character, Texture> glyphs;

    public Font(InputStream path, float size) {
        try {
            java.awt.Font font = java.awt.Font.createFont(0, path);
            this.font = font.deriveFont(size);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
    }

    public Texture renderTextToImage(String text) {
        return this.renderTextToImage(text, 1, 1);
    }

    public Texture renderTextToImage(String text, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setFont(this.font);
        int width = g2d.getFontMetrics().stringWidth(text);
        int height = g2d.getFontMetrics().getHeight();
        g2d.dispose();
        image = new BufferedImage(width, height, 2);
        g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setFont(this.font);
        g2d.drawString(text, 0, g2d.getFontMetrics().getAscent());
        g2d.dispose();
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = ByteBuffer.allocateDirect(image.getWidth() * image.getHeight() * 4);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[(image.getHeight() - 1 - y) * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return Texture.createTexture(width, height, buffer);
    }

    public HashMap<Character, Texture> getGlyphs() {
        return this.getGlyphs(1, 1);
    }

    public HashMap<Character, Texture> getGlyphs(int w, int h) {
        if (this.glyphs != null) {
            return this.glyphs;
        }
        this.glyphs = new HashMap();
        for (int i = 32; i <= 126; ++i) {
            this.glyphs.put(Character.valueOf((char)i), this.renderTextToImage(String.valueOf((char)i), w, h));
        }
        return this.glyphs;
    }
}

