/*
 * Decompiled with CFR 0.152.
 */
package net.k3nder.gravity;

import java.util.List;
import net.k3nder.gravity.AABB;
import net.k3nder.gravity.SpatialGrid;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CollisionDetector {
    private SpatialGrid grid;

    public CollisionDetector(SpatialGrid grid) {
        this.grid = grid;
    }

    public void add(AABB box) {
        this.grid.add(box);
    }

    public boolean detectCollisions(AABB box) {
        List<AABB> candidates = this.grid.getNearbyBoxes(box);
        for (AABB candidate : candidates) {
            if (box == candidate || !box.intersects(candidate)) continue;
            return true;
        }
        return false;
    }

    public Vector3f resolveCollision(AABB box, Vector3f velocity) {
        Vector3f resolvedPosition = new Vector3f((Vector3fc)box.getMin());
        List<AABB> candidates = this.grid.getNearbyBoxes(box);
        for (AABB candidate : candidates) {
            if (box == candidate || !box.intersects(candidate)) continue;
            Vector3f correction = new Vector3f();
            if (velocity.x > 0.0f) {
                correction.x = candidate.getMin().x - box.getMax().x;
            } else if (velocity.x < 0.0f) {
                correction.x = candidate.getMax().x - box.getMin().x;
            }
            if (velocity.y > 0.0f) {
                correction.y = candidate.getMin().y - box.getMax().y;
            } else if (velocity.y < 0.0f) {
                correction.y = candidate.getMax().y - box.getMin().y;
            }
            if (velocity.z > 0.0f) {
                correction.z = candidate.getMin().z - box.getMax().z;
            } else if (velocity.z < 0.0f) {
                correction.z = candidate.getMax().z - box.getMin().z;
            }
            resolvedPosition.add((Vector3fc)correction);
            if (Math.abs(correction.x) > 0.0f) {
                velocity.x = 0.0f;
            }
            if (Math.abs(correction.y) > 0.0f) {
                velocity.y = 0.0f;
            }
            if (!(Math.abs(correction.z) > 0.0f)) continue;
            velocity.z = 0.0f;
        }
        return resolvedPosition;
    }
}

