/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.common.builders;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.matcher.ViewMatchers;
import io.github.kakaocup.kakao.common.KakaoDslMarker;
import io.github.kakaocup.kakao.common.matchers.AnyTextMatcher;
import io.github.kakaocup.kakao.common.matchers.BackgroundColorMatcher;
import io.github.kakaocup.kakao.common.matchers.DrawableMatcher;
import io.github.kakaocup.kakao.common.matchers.FirstViewMatcher;
import io.github.kakaocup.kakao.common.matchers.IndexMatcher;
import io.github.kakaocup.kakao.common.matchers.RatingBarMatcher;
import io.github.kakaocup.kakao.common.matchers.ViewGroupPositionMatcher;
import io.github.kakaocup.kakao.delegate.ViewInteractionDelegate;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KakaoDslMarker
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010\u000f\u001a\u00020\t2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0011J\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\tJ\u001f\u0010\u0014\u001a\u00020\t2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\b\u0017J\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\tJ\u0012\u0010\u001d\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\tJ\u0006\u0010!\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\tJ\u0010\u0010(\u001a\u00020\t2\b\b\u0001\u0010)\u001a\u00020&J\u000e\u0010(\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u000bJ\u0014\u0010+\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005J\u0010\u0010-\u001a\u00020\t2\b\b\u0001\u0010.\u001a\u00020&J\u000e\u0010-\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u000bJ\u001f\u00100\u001a\u00020\t2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\b\u0017J5\u00101\u001a\u00020\t2\u0006\u00102\u001a\u0002032%\b\u0002\u00104\u001a\u001f\u0012\u0013\u0012\u001103\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\b(2\u0012\u0004\u0012\u000207\u0018\u00010\u0016J7\u00101\u001a\u00020\t2\b\b\u0001\u0010)\u001a\u00020&2%\b\u0002\u00104\u001a\u001f\u0012\u0013\u0012\u001103\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\b(2\u0012\u0004\u0012\u000207\u0018\u00010\u0016J\u000e\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020&J'\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020&2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\b\u0017J\u0014\u0010<\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001f\u0010=\u001a\u00020\t2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\b\u0017J\u000e\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020\t2\u0006\u00106\u001a\u00020\u000bJ\u0014\u0010A\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005J\u001f\u0010B\u001a\u00020\t2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\b\u0017J\u000e\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\u0001J\u0010\u0010E\u001a\u00020\t2\b\b\u0001\u0010F\u001a\u00020&J\u000e\u0010E\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010E\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005J\u0010\u0010G\u001a\u00020\t2\b\b\u0001\u0010)\u001a\u00020&J\u000e\u0010G\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR*\u0010\u0003\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lio/github/kakaocup/kakao/common/builders/ViewBuilder;", "", "()V", "viewMatchers", "Ljava/util/ArrayList;", "Lorg/hamcrest/Matcher;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "containsText", "", "text", "", "getViewInteractionDelegate", "Lio/github/kakaocup/kakao/delegate/ViewInteractionDelegate;", "getViewMatcher", "isAssignableFrom", "clazz", "Ljava/lang/Class;", "isClickable", "isCompletelyDisplayed", "isDescendantOfA", "function", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isDisabled", "isDisplayed", "isEnabled", "isFirst", "isGone", "isInstanceOf", "isInvisible", "isNotClickable", "isNotCompletelyDisplayed", "isNotDisplayed", "isRoot", "isVisible", "onPosition", "position", "", "withAnyText", "withBackgroundColor", "resId", "colorCode", "withClassName", "matcher", "withContentDescription", "resourceId", "description", "withDescendant", "withDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "toBitmap", "Lkotlin/ParameterName;", "name", "Landroid/graphics/Bitmap;", "withId", "id", "withIndex", "index", "withMatcher", "withParent", "withRating", "rating", "", "withResourceName", "withSibling", "withTag", "tag", "withText", "textId", "withoutText", "kakao_release"})
public final class ViewBuilder {
    private final ArrayList<Matcher<View>> viewMatchers;

    public final void withIndex(int index, @NotNull Function1<? super ViewBuilder, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewBuilder viewBuilder = new ViewBuilder();
        boolean bl = false;
        boolean bl2 = false;
        function.invoke((Object)viewBuilder);
        this.viewMatchers.add((Matcher<View>)new IndexMatcher(viewBuilder.getViewMatcher(), index));
    }

    public final void onPosition(int position) {
        this.viewMatchers.add((Matcher<View>)new ViewGroupPositionMatcher(position));
    }

    public final void isRoot() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.isRoot());
    }

    public final void withId(int id) {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withId((int)id));
    }

    public final void withTag(@NotNull Object tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withTagValue((Matcher)Matchers.equalTo((Object)tag)));
    }

    public final void isEnabled() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.isEnabled());
    }

    public final void isDisabled() {
        this.viewMatchers.add((Matcher<View>)CoreMatchers.not((Matcher)ViewMatchers.isEnabled()));
    }

    public final void withText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withText((String)text2));
    }

    public final void withText(@StringRes int textId) {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withText((int)textId));
    }

    public final void withText(@NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withText(matcher));
    }

    public final void withoutText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.viewMatchers.add((Matcher<View>)CoreMatchers.not((Matcher)ViewMatchers.withText((String)text2)));
    }

    public final void withoutText(@StringRes int resId) {
        this.viewMatchers.add((Matcher<View>)CoreMatchers.not((Matcher)ViewMatchers.withText((int)resId)));
    }

    public final void withAnyText() {
        this.viewMatchers.add((Matcher<View>)new AnyTextMatcher());
    }

    public final void containsText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withText((Matcher)Matchers.containsString((String)text2)));
    }

    public final void withResourceName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withResourceName((String)name));
    }

    public final void withResourceName(@NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withResourceName(matcher));
    }

    public final void withContentDescription(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withContentDescription((String)description));
    }

    public final void withContentDescription(@StringRes int resourceId) {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withContentDescription((int)resourceId));
    }

    public final void withParent(@NotNull Function1<? super ViewBuilder, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewBuilder viewBuilder = new ViewBuilder();
        boolean bl = false;
        boolean bl2 = false;
        function.invoke((Object)viewBuilder);
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withParent(viewBuilder.getViewMatcher()));
    }

    public final void withDrawable(@DrawableRes int resId, @Nullable Function1<? super Drawable, Bitmap> toBitmap) {
        this.viewMatchers.add((Matcher<View>)new DrawableMatcher(resId, null, null, toBitmap, 6, null));
    }

    public static /* synthetic */ void withDrawable$default(ViewBuilder viewBuilder, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = null;
        }
        viewBuilder.withDrawable(n, (Function1<? super Drawable, Bitmap>)function1);
    }

    public final void withRating(float rating) {
        this.viewMatchers.add((Matcher<View>)new RatingBarMatcher(rating));
    }

    public final void withDrawable(@NotNull Drawable drawable, @Nullable Function1<? super Drawable, Bitmap> toBitmap) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this.viewMatchers.add((Matcher<View>)new DrawableMatcher(0, drawable, null, toBitmap, 5, null));
    }

    public static /* synthetic */ void withDrawable$default(ViewBuilder viewBuilder, Drawable drawable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        viewBuilder.withDrawable(drawable, (Function1<? super Drawable, Bitmap>)function1);
    }

    public final void withBackgroundColor(@ColorRes int resId) {
        this.viewMatchers.add((Matcher<View>)new BackgroundColorMatcher(resId, null, 2, null));
    }

    public final void withBackgroundColor(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        this.viewMatchers.add((Matcher<View>)new BackgroundColorMatcher(0, colorCode, 1, null));
    }

    public final void isFirst() {
        this.viewMatchers.add((Matcher<View>)new FirstViewMatcher());
    }

    public final void isVisible() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withEffectiveVisibility((ViewMatchers.Visibility)ViewMatchers.Visibility.VISIBLE));
    }

    public final void isInvisible() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withEffectiveVisibility((ViewMatchers.Visibility)ViewMatchers.Visibility.INVISIBLE));
    }

    public final void isGone() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withEffectiveVisibility((ViewMatchers.Visibility)ViewMatchers.Visibility.GONE));
    }

    public final void isDisplayed() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.isDisplayed());
    }

    public final void isNotDisplayed() {
        this.viewMatchers.add((Matcher<View>)Matchers.not((Matcher)ViewMatchers.isDisplayed()));
    }

    public final void isCompletelyDisplayed() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.isCompletelyDisplayed());
    }

    public final void isNotCompletelyDisplayed() {
        this.viewMatchers.add((Matcher<View>)Matchers.not((Matcher)ViewMatchers.isCompletelyDisplayed()));
    }

    public final void isClickable() {
        this.viewMatchers.add((Matcher<View>)ViewMatchers.isClickable());
    }

    public final void isNotClickable() {
        this.viewMatchers.add((Matcher<View>)Matchers.not((Matcher)ViewMatchers.isClickable()));
    }

    public final void isDescendantOfA(@NotNull Function1<? super ViewBuilder, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewBuilder viewBuilder = new ViewBuilder();
        boolean bl = false;
        boolean bl2 = false;
        function.invoke((Object)viewBuilder);
        this.viewMatchers.add((Matcher<View>)ViewMatchers.isDescendantOfA(viewBuilder.getViewMatcher()));
    }

    public final void withDescendant(@NotNull Function1<? super ViewBuilder, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewBuilder viewBuilder = new ViewBuilder();
        boolean bl = false;
        boolean bl2 = false;
        function.invoke((Object)viewBuilder);
        this.viewMatchers.add((Matcher<View>)ViewMatchers.hasDescendant(viewBuilder.getViewMatcher()));
    }

    public final void withSibling(@NotNull Function1<? super ViewBuilder, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewBuilder viewBuilder = new ViewBuilder();
        boolean bl = false;
        boolean bl2 = false;
        function.invoke((Object)viewBuilder);
        this.viewMatchers.add((Matcher<View>)ViewMatchers.hasSibling(viewBuilder.getViewMatcher()));
    }

    public final void withClassName(@NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.withClassName(matcher));
    }

    public final void isInstanceOf(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.viewMatchers.add((Matcher<View>)Matchers.instanceOf(clazz));
    }

    public final void isAssignableFrom(@NotNull Class<? extends View> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.viewMatchers.add((Matcher<View>)ViewMatchers.isAssignableFrom(clazz));
    }

    public final void withMatcher(@NotNull Matcher<View> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.viewMatchers.add(matcher);
    }

    @NotNull
    public final ViewInteractionDelegate getViewInteractionDelegate() {
        Collection collection = this.viewMatchers;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "No matchers inside InteractionBuilder";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ViewInteraction viewInteraction = Espresso.onView((Matcher)AllOf.allOf((Iterable)this.viewMatchers));
        Intrinsics.checkNotNullExpressionValue((Object)viewInteraction, (String)"Espresso.onView(AllOf.allOf(viewMatchers))");
        return new ViewInteractionDelegate(viewInteraction);
    }

    @NotNull
    public final Matcher<View> getViewMatcher() {
        Matcher matcher = AllOf.allOf((Iterable)this.viewMatchers);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"AllOf.allOf(viewMatchers)");
        return matcher;
    }

    public ViewBuilder() {
        boolean bl = false;
        this.viewMatchers = new ArrayList();
    }
}

