/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.common.matchers;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ColorRes;
import io.github.kakaocup.kakao.common.utilities.ContextUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0003\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/kakaocup/kakao/common/matchers/BackgroundColorMatcher;", "Lorg/hamcrest/TypeSafeMatcher;", "Landroid/view/View;", "resId", "", "colorCode", "", "(ILjava/lang/String;)V", "describeTo", "", "description", "Lorg/hamcrest/Description;", "matchesSafely", "", "item", "kakao_release"})
public final class BackgroundColorMatcher
extends TypeSafeMatcher<View> {
    private final int resId;
    private final String colorCode;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean matchesSafely(@Nullable View item) {
        boolean bl;
        boolean bl2;
        CharSequence charSequence;
        if (this.resId == -1) {
            charSequence = this.colorCode;
            bl2 = false;
            bl = false;
            if (charSequence == null || charSequence.length() == 0) {
                View view = item;
                if (view == null) return true;
                Drawable drawable = view.getBackground();
                if (drawable != null) return false;
                return true;
            }
        }
        View view = item;
        if (view == null) return false;
        charSequence = view;
        bl2 = false;
        bl = false;
        CharSequence it = charSequence;
        boolean bl3 = false;
        int expectedColor = this.resId != -1 ? ContextUtilsKt.getResourceColor(this.resId) : Color.parseColor((String)this.colorCode);
        if (it.getBackground() == null) return false;
        Drawable drawable = it.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"it.background");
        if (!(drawable.getCurrent() instanceof ColorDrawable)) return false;
        Drawable drawable2 = it.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"it.background");
        Drawable drawable3 = drawable2.getCurrent();
        if (drawable3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.ColorDrawable");
        }
        if (((ColorDrawable)drawable3).getColor() != expectedColor) return false;
        return true;
    }

    public void describeTo(@NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        description.appendText("with background color: " + this.resId + " or " + this.colorCode);
    }

    public BackgroundColorMatcher(@ColorRes int resId, @Nullable String colorCode) {
        this.resId = resId;
        this.colorCode = colorCode;
    }

    public /* synthetic */ BackgroundColorMatcher(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        this(n, string);
    }

    public BackgroundColorMatcher() {
        this(0, null, 3, null);
    }
}

