/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.common.matchers;

import android.view.View;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/kakaocup/kakao/common/matchers/IndexMatcher;", "Lorg/hamcrest/TypeSafeMatcher;", "Landroid/view/View;", "matcher", "Lorg/hamcrest/Matcher;", "index", "", "(Lorg/hamcrest/Matcher;I)V", "currentIndex", "seen", "", "describeTo", "", "desc", "Lorg/hamcrest/Description;", "matchesSafely", "", "view", "kakao_release"})
public final class IndexMatcher
extends TypeSafeMatcher<View> {
    private int currentIndex;
    private final Set<View> seen;
    private final Matcher<View> matcher;
    private final int index;

    public void describeTo(@NotNull Description desc) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        desc.appendText(this.index + "th view with: ").appendDescriptionOf((SelfDescribing)this.matcher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchesSafely(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.seen.contains(view)) {
            this.currentIndex = 0;
            this.seen.clear();
        }
        this.seen.add(view);
        if (!this.matcher.matches((Object)view)) return false;
        int n = this.currentIndex;
        this.currentIndex = n + 1;
        if (n != this.index) return false;
        return true;
    }

    public IndexMatcher(@NotNull Matcher<View> matcher, int index) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.matcher = matcher;
        this.index = index;
        boolean bl = false;
        this.seen = new LinkedHashSet();
    }
}

