/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.common.matchers;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.test.espresso.matcher.BoundedMatcher;
import io.github.kakaocup.kakao.common.extentions.ExtentionsKt;
import io.github.kakaocup.kakao.common.utilities.ContextUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Description;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB,\u0012%\b\u0002\u0010\n\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\tR+\u0010\n\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/kakaocup/kakao/common/matchers/ToolbarNavigationMatcher;", "Landroidx/test/espresso/matcher/BoundedMatcher;", "Landroid/view/View;", "Landroidx/appcompat/widget/Toolbar;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "resId", "", "(I)V", "toBitmap", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Landroid/graphics/Bitmap;", "(Lkotlin/jvm/functions/Function1;)V", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "getResId", "()I", "setResId", "describeTo", "", "desc", "Lorg/hamcrest/Description;", "matchesSafely", "", "view", "kakao_release"})
public final class ToolbarNavigationMatcher
extends BoundedMatcher<View, Toolbar> {
    @DrawableRes
    private int resId;
    @Nullable
    private Drawable drawable;
    private final Function1<Drawable, Bitmap> toBitmap;

    public final int getResId() {
        return this.resId;
    }

    public final void setResId(int n) {
        this.resId = n;
    }

    @Nullable
    public final Drawable getDrawable() {
        return this.drawable;
    }

    public final void setDrawable(@Nullable Drawable drawable) {
        this.drawable = drawable;
    }

    public void describeTo(@NotNull Description desc) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        desc.appendText("Drawable is not equal");
    }

    protected boolean matchesSafely(@NotNull Toolbar view) {
        Bitmap bitmap;
        Bitmap bitmap2;
        Drawable expectedDrawable;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.resId < 0 && this.drawable == null) {
            return false;
        }
        Drawable drawable = this.drawable;
        if (drawable == null) {
            drawable = expectedDrawable = ContextUtilsKt.getResourceDrawable(this.resId);
        }
        if (Build.VERSION.SDK_INT < 21 && expectedDrawable != null) {
            expectedDrawable = DrawableCompat.wrap((Drawable)expectedDrawable).mutate();
        }
        if (expectedDrawable == null) {
            return false;
        }
        Drawable drawable2 = view.getNavigationIcon();
        if (drawable2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"view.navigationIcon ?: return false");
        Drawable convertDrawable = drawable2;
        Bitmap bitmap3 = this.toBitmap;
        if (bitmap3 == null || (bitmap3 = (Bitmap)bitmap3.invoke((Object)convertDrawable)) == null) {
            bitmap3 = bitmap2 = ExtentionsKt.toBitmap(convertDrawable);
        }
        if ((bitmap = this.toBitmap) == null || (bitmap = (Bitmap)bitmap.invoke((Object)expectedDrawable)) == null) {
            bitmap = ExtentionsKt.toBitmap(expectedDrawable);
        }
        Bitmap otherBitmap = bitmap;
        return bitmap2.sameAs(otherBitmap);
    }

    public ToolbarNavigationMatcher(@Nullable Function1<? super Drawable, Bitmap> toBitmap) {
        super(Toolbar.class);
        this.toBitmap = toBitmap;
        this.resId = -1;
    }

    public /* synthetic */ ToolbarNavigationMatcher(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this((Function1<? super Drawable, Bitmap>)function1);
    }

    public ToolbarNavigationMatcher() {
        this(null, 1, null);
    }

    public ToolbarNavigationMatcher(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this(null, 1, null);
        this.drawable = drawable;
    }

    public ToolbarNavigationMatcher(@DrawableRes int resId) {
        this(null, 1, null);
        this.resId = resId;
    }
}

