/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.common.utilities;

import android.app.Instrumentation;
import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.test.platform.app.InstrumentationRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u0001\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"getResourceColor", "", "resId", "getResourceDrawable", "Landroid/graphics/drawable/Drawable;", "getResourceString", "", "kakao_release"})
public final class ContextUtilsKt {
    @NotNull
    public static final String getResourceString(@StringRes int resId) {
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"InstrumentationRegistry.getInstrumentation()");
        Context context = instrumentation.getTargetContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"InstrumentationRegistry.\u2026mentation().targetContext");
        String string = context.getResources().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"InstrumentationRegistry.\u2026esources.getString(resId)");
        return string;
    }

    @Nullable
    public static final Drawable getResourceDrawable(@DrawableRes int resId) {
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"InstrumentationRegistry.getInstrumentation()");
        return ContextCompat.getDrawable((Context)instrumentation.getTargetContext(), (int)resId);
    }

    public static final int getResourceColor(@ColorRes int resId) {
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"InstrumentationRegistry.getInstrumentation()");
        return ContextCompat.getColor((Context)instrumentation.getTargetContext(), (int)resId);
    }
}

