/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.edit;

import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.assertion.ViewAssertions;
import com.google.android.material.textfield.TextInputLayout;
import io.github.kakaocup.kakao.common.assertions.BaseAssertions;
import io.github.kakaocup.kakao.common.builders.RootBuilder;
import io.github.kakaocup.kakao.common.builders.ViewBuilder;
import io.github.kakaocup.kakao.common.matchers.TextInputLayoutCounterEnabledMatcher;
import io.github.kakaocup.kakao.common.matchers.TextInputLayoutErrorEnabledMatcher;
import io.github.kakaocup.kakao.common.matchers.TextInputLayoutHintEnabledMatcher;
import io.github.kakaocup.kakao.common.utilities.ContextUtilsKt;
import io.github.kakaocup.kakao.delegate.ViewInteractionDelegate;
import io.github.kakaocup.kakao.edit.TextInputLayoutAssertions;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u00020\u00032\b\b\u0001\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00032\b\b\u0001\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016\u00a8\u0006\u0013"}, d2={"Lio/github/kakaocup/kakao/edit/TextInputLayoutAssertions;", "Lio/github/kakaocup/kakao/common/assertions/BaseAssertions;", "hasCounterMaxLength", "", "length", "", "hasError", "resId", "error", "", "hasHint", "hint", "hasNoError", "isCounterDisabled", "isCounterEnabled", "isErrorDisabled", "isErrorEnabled", "isHintDisabled", "isHintEnabled", "kakao_release"})
public interface TextInputLayoutAssertions
extends BaseAssertions {
    public void hasHint(@NotNull String var1);

    public void hasHint(@StringRes int var1);

    public void isHintEnabled();

    public void isHintDisabled();

    public void hasError(@StringRes int var1);

    public void hasError(@NotNull String var1);

    public void hasNoError();

    public void isErrorEnabled();

    public void isErrorDisabled();

    public void hasCounterMaxLength(int var1);

    public void isCounterEnabled();

    public void isCounterDisabled();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void hasHint(@NotNull TextInputLayoutAssertions $this, @NotNull String hint) {
            Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
            $this.getView().check(new ViewAssertion(hint){
                final /* synthetic */ String $hint;

                public final void check(View view, NoMatchingViewException notFoundException) {
                    if (view instanceof TextInputLayout) {
                        if (Intrinsics.areEqual((Object)this.$hint, (Object)((TextInputLayout)view).getHint()) ^ true) {
                            throw (Throwable)((Object)new AssertionError((Object)("Expected hint is " + this.$hint + ',' + " but actual is " + ((TextInputLayout)view).getHint())));
                        }
                    } else {
                        NoMatchingViewException noMatchingViewException = notFoundException;
                        if (noMatchingViewException != null) {
                            NoMatchingViewException noMatchingViewException2 = noMatchingViewException;
                            boolean bl = false;
                            boolean bl2 = false;
                            NoMatchingViewException it = noMatchingViewException2;
                            boolean bl3 = false;
                            throw (Throwable)((Object)new AssertionError(it));
                        }
                    }
                }
                {
                    this.$hint = string;
                }
            });
        }

        public static void hasHint(@NotNull TextInputLayoutAssertions $this, @StringRes int resId) {
            $this.hasHint(ContextUtilsKt.getResourceString(resId));
        }

        public static void isHintEnabled(@NotNull TextInputLayoutAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new TextInputLayoutHintEnabledMatcher(true)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026HintEnabledMatcher(true))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void isHintDisabled(@NotNull TextInputLayoutAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new TextInputLayoutHintEnabledMatcher(false)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026intEnabledMatcher(false))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasError(@NotNull TextInputLayoutAssertions $this, @StringRes int resId) {
            $this.hasError(ContextUtilsKt.getResourceString(resId));
        }

        public static void hasError(@NotNull TextInputLayoutAssertions $this, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            $this.getView().check(new ViewAssertion(error){
                final /* synthetic */ String $error;

                public final void check(View view, NoMatchingViewException notFoundException) {
                    if (view instanceof TextInputLayout) {
                        if (Intrinsics.areEqual((Object)this.$error, (Object)((TextInputLayout)view).getError()) ^ true) {
                            throw (Throwable)((Object)new AssertionError((Object)("Expected error is " + this.$error + ',' + " but actual is " + ((TextInputLayout)view).getError())));
                        }
                    } else {
                        NoMatchingViewException noMatchingViewException = notFoundException;
                        if (noMatchingViewException != null) {
                            NoMatchingViewException noMatchingViewException2 = noMatchingViewException;
                            boolean bl = false;
                            boolean bl2 = false;
                            NoMatchingViewException it = noMatchingViewException2;
                            boolean bl3 = false;
                            throw (Throwable)((Object)new AssertionError(it));
                        }
                    }
                }
                {
                    this.$error = string;
                }
            });
        }

        public static void hasNoError(@NotNull TextInputLayoutAssertions $this) {
            $this.getView().check(hasNoError.1.INSTANCE);
        }

        public static void isErrorEnabled(@NotNull TextInputLayoutAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new TextInputLayoutErrorEnabledMatcher(true)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026rrorEnabledMatcher(true))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void isErrorDisabled(@NotNull TextInputLayoutAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new TextInputLayoutErrorEnabledMatcher(false)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026rorEnabledMatcher(false))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasCounterMaxLength(@NotNull TextInputLayoutAssertions $this, int length) {
            $this.getView().check(new ViewAssertion(length){
                final /* synthetic */ int $length;

                public final void check(View view, NoMatchingViewException notFoundException) {
                    if (view instanceof TextInputLayout) {
                        if (this.$length != ((TextInputLayout)view).getCounterMaxLength()) {
                            throw (Throwable)((Object)new AssertionError((Object)("Expected counter max length is " + this.$length + ',' + " but actual is " + ((TextInputLayout)view).getCounterMaxLength())));
                        }
                    } else {
                        NoMatchingViewException noMatchingViewException = notFoundException;
                        if (noMatchingViewException != null) {
                            NoMatchingViewException noMatchingViewException2 = noMatchingViewException;
                            boolean bl = false;
                            boolean bl2 = false;
                            NoMatchingViewException it = noMatchingViewException2;
                            boolean bl3 = false;
                            throw (Throwable)((Object)new AssertionError(it));
                        }
                    }
                }
                {
                    this.$length = n;
                }
            });
        }

        public static void isCounterEnabled(@NotNull TextInputLayoutAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new TextInputLayoutCounterEnabledMatcher(true)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026nterEnabledMatcher(true))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void isCounterDisabled(@NotNull TextInputLayoutAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new TextInputLayoutCounterEnabledMatcher(false)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026terEnabledMatcher(false))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void isDisplayed(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isDisplayed($this);
        }

        public static void isNotDisplayed(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isNotDisplayed($this);
        }

        public static void isCompletelyDisplayed(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isCompletelyDisplayed($this);
        }

        public static void isNotCompletelyDisplayed(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isNotCompletelyDisplayed($this);
        }

        public static void isVisible(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isVisible($this);
        }

        public static void isInvisible(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isInvisible($this);
        }

        public static void isGone(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isGone($this);
        }

        public static void isSelected(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isSelected($this);
        }

        public static void isNotSelected(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isNotSelected($this);
        }

        public static void isFocused(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isFocused($this);
        }

        public static void isNotFocused(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocused($this);
        }

        public static void isFocusable(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isFocusable($this);
        }

        public static void isNotFocusable(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocusable($this);
        }

        public static void isClickable(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isClickable($this);
        }

        public static void isNotClickable(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isNotClickable($this);
        }

        public static void isEnabled(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isEnabled($this);
        }

        public static void isDisabled(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.isDisabled($this);
        }

        public static void hasTag(@NotNull TextInputLayoutAssertions $this, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            BaseAssertions.DefaultImpls.hasTag($this, tag);
        }

        public static void hasAnyTag(@NotNull TextInputLayoutAssertions $this, String ... tags) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            BaseAssertions.DefaultImpls.hasAnyTag($this, tags);
        }

        public static void doesNotExist(@NotNull TextInputLayoutAssertions $this) {
            BaseAssertions.DefaultImpls.doesNotExist($this);
        }

        public static void hasDescendant(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasDescendant($this, function);
        }

        public static void hasNotDescendant(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotDescendant($this, function);
        }

        public static void hasSibling(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasSibling($this, function);
        }

        public static void hasNotSibling(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotSibling($this, function);
        }

        public static void matches(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.matches($this, function);
        }

        public static void notMatches(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.notMatches($this, function);
        }

        public static void assert(@NotNull TextInputLayoutAssertions $this, @NotNull Function0<? extends ViewAssertion> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.assert($this, function);
        }

        public static void inRoot(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super RootBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.inRoot($this, function);
        }

        public static void hasBackgroundColor(@NotNull TextInputLayoutAssertions $this, @ColorRes int resId) {
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, resId);
        }

        public static void hasBackgroundColor(@NotNull TextInputLayoutAssertions $this, @NotNull String colorCode) {
            Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, colorCode);
        }

        public static void isCompletelyAbove(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyAbove($this, function);
        }

        public static void isCompletelyBelow(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyBelow($this, function);
        }

        public static void isCompletelyLeftOf(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyLeftOf($this, function);
        }

        public static void isCompletelyRightOf(@NotNull TextInputLayoutAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyRightOf($this, function);
        }
    }
}

