/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.intent;

import android.net.Uri;
import androidx.test.espresso.intent.matcher.UriMatchers;
import io.github.kakaocup.kakao.common.KakaoDslMarker;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.jetbrains.annotations.NotNull;

@KakaoDslMarker
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ\"\u0010\u000f\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fJ\u0014\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fJ\u0014\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\"\u0010\u0015\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0005R*\u0010\u0003\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/kakaocup/kakao/intent/UriBuilder;", "", "()V", "matchers", "Ljava/util/ArrayList;", "Lorg/hamcrest/Matcher;", "Landroid/net/Uri;", "Lkotlin/collections/ArrayList;", "getMatcher", "hasHost", "", "host", "", "hasParamWithName", "name", "hasParamWithValue", "value", "hasPath", "path", "hasScheme", "scheme", "hasSchemeSpecificPart", "part", "kakao_release"})
public final class UriBuilder {
    private final ArrayList<Matcher<Uri>> matchers;

    public final void hasHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasHost((String)host));
    }

    public final void hasHost(@NotNull Matcher<String> host) {
        Intrinsics.checkNotNullParameter(host, (String)"host");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasHost(host));
    }

    public final void hasPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasPath((String)path));
    }

    public final void hasPath(@NotNull Matcher<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasPath(path));
    }

    public final void hasScheme(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasScheme((String)scheme));
    }

    public final void hasScheme(@NotNull Matcher<String> scheme) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasScheme(scheme));
    }

    public final void hasParamWithName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasParamWithName((String)name));
    }

    public final void hasParamWithName(@NotNull Matcher<String> name) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasParamWithName(name));
    }

    public final void hasParamWithValue(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasParamWithValue((String)name, (String)value));
    }

    public final void hasParamWithValue(@NotNull Matcher<String> name, @NotNull Matcher<String> value) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasParamWithValue(name, value));
    }

    public final void hasSchemeSpecificPart(@NotNull String scheme, @NotNull String part) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasSchemeSpecificPart((String)scheme, (String)part));
    }

    public final void hasSchemeSpecificPart(@NotNull Matcher<String> scheme, @NotNull Matcher<String> part) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter(part, (String)"part");
        this.matchers.add((Matcher<Uri>)UriMatchers.hasSchemeSpecificPart(scheme, part));
    }

    @NotNull
    public final Matcher<Uri> getMatcher() {
        Matcher matcher = AllOf.allOf((Iterable)this.matchers);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"AllOf.allOf(matchers)");
        return matcher;
    }

    public UriBuilder() {
        boolean bl = false;
        this.matchers = new ArrayList();
    }
}

