/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.pager2;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.viewpager2.widget.ViewPager2;
import io.github.kakaocup.kakao.common.actions.ScrollableActions;
import io.github.kakaocup.kakao.common.actions.SwipeableActions;
import io.github.kakaocup.kakao.common.builders.ViewBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u00012\u00020\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lio/github/kakaocup/kakao/pager2/ViewPager2Actions;", "Lio/github/kakaocup/kakao/common/actions/ScrollableActions;", "Lio/github/kakaocup/kakao/common/actions/SwipeableActions;", "getSize", "", "scrollTo", "", "position", "scrollToEnd", "scrollToStart", "kakao_release"})
public interface ViewPager2Actions
extends ScrollableActions,
SwipeableActions {
    @Override
    public void scrollToStart();

    @Override
    public void scrollToEnd();

    @Override
    public void scrollTo(int var1);

    public int getSize();

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void scrollToStart(@NotNull ViewPager2Actions $this) {
            $this.getView().perform(new ViewAction(){

                @NotNull
                public String getDescription() {
                    return "Scroll view pager 2 to the start";
                }

                public Matcher<View> getConstraints() {
                    return ViewMatchers.isAssignableFrom(ViewPager2.class);
                }

                public void perform(@NotNull UiController controller, @NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    if (view instanceof ViewPager2) {
                        ((ViewPager2)view).setCurrentItem(0, false);
                        controller.loopMainThreadUntilIdle();
                    }
                }
            });
        }

        public static void scrollToEnd(@NotNull ViewPager2Actions $this) {
            $this.getView().perform(new ViewAction(){

                @NotNull
                public String getDescription() {
                    return "Scroll view pager 2 to the end";
                }

                public Matcher<View> getConstraints() {
                    return ViewMatchers.isAssignableFrom(ViewPager2.class);
                }

                public void perform(@NotNull UiController controller, @NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    if (view instanceof ViewPager2) {
                        int n;
                        RecyclerView.Adapter adapter = ((ViewPager2)view).getAdapter();
                        if (adapter != null) {
                            int n2 = adapter.getItemCount();
                            boolean bl = false;
                            boolean bl2 = false;
                            int it = n2;
                            boolean bl3 = false;
                            n = it - 1;
                        } else {
                            n = 0;
                        }
                        int endPosition = n;
                        ((ViewPager2)view).setCurrentItem(endPosition, false);
                        controller.loopMainThreadUntilIdle();
                    }
                }
            });
        }

        public static void scrollTo(@NotNull ViewPager2Actions $this, int position) {
            $this.getView().perform(new ViewAction(position){
                final /* synthetic */ int $position;

                @NotNull
                public String getDescription() {
                    return "Scroll view pager 2 to specific position";
                }

                public Matcher<View> getConstraints() {
                    return ViewMatchers.isAssignableFrom(ViewPager2.class);
                }

                public void perform(@NotNull UiController controller, @NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    if (view instanceof ViewPager2) {
                        ((ViewPager2)view).setCurrentItem(this.$position, false);
                        controller.loopMainThreadUntilIdle();
                    }
                }
                {
                    this.$position = $captured_local_variable$0;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public static int getSize(@NotNull ViewPager2Actions $this) {
            void size;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            $this.getView().perform(new ViewAction((Ref.IntRef)size){
                final /* synthetic */ Ref.IntRef $size;

                @NotNull
                public String getDescription() {
                    return "Get view pager adapter size";
                }

                public Matcher<View> getConstraints() {
                    return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(ViewPager2.class), (Matcher)ViewMatchers.isDisplayed());
                }

                public void perform(@Nullable UiController uiController, @Nullable View view) {
                    if (view instanceof ViewPager2) {
                        RecyclerView.Adapter adapter = ((ViewPager2)view).getAdapter();
                        Integer n = adapter != null ? Integer.valueOf(adapter.getItemCount()) : null;
                        Intrinsics.checkNotNull((Object)n);
                        this.$size.element = n;
                    }
                }
                {
                    this.$size = $captured_local_variable$0;
                }
            });
            return size.element;
        }

        public static void scrollTo(@NotNull ViewPager2Actions $this) {
            ScrollableActions.DefaultImpls.scrollTo($this);
        }

        public static void click(@NotNull ViewPager2Actions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.click($this, location);
        }

        public static void doubleClick(@NotNull ViewPager2Actions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.doubleClick($this, location);
        }

        public static void longClick(@NotNull ViewPager2Actions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.longClick($this, location);
        }

        public static void pressImeAction(@NotNull ViewPager2Actions $this) {
            ScrollableActions.DefaultImpls.pressImeAction($this);
        }

        public static void act(@NotNull ViewPager2Actions $this, @NotNull Function0<? extends ViewAction> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            ScrollableActions.DefaultImpls.act($this, function);
        }

        public static void onFailure(@NotNull ViewPager2Actions $this, @NotNull Function2<? super Throwable, ? super Matcher<View>, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            ScrollableActions.DefaultImpls.onFailure($this, function);
        }

        public static void repeatUntil(@NotNull ViewPager2Actions $this, int maxAttempts, @NotNull Function0<? extends ViewAction> action2, @NotNull Function1<? super ViewBuilder, Unit> matcher) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            ScrollableActions.DefaultImpls.repeatUntil($this, maxAttempts, action2, matcher);
        }

        public static void swipeLeft(@NotNull ViewPager2Actions $this) {
            SwipeableActions.DefaultImpls.swipeLeft($this);
        }

        public static void swipeRight(@NotNull ViewPager2Actions $this) {
            SwipeableActions.DefaultImpls.swipeRight($this);
        }

        public static void swipeUp(@NotNull ViewPager2Actions $this) {
            SwipeableActions.DefaultImpls.swipeUp($this);
        }

        public static void swipeDown(@NotNull ViewPager2Actions $this) {
            SwipeableActions.DefaultImpls.swipeDown($this);
        }
    }
}

