/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.progress;

import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/kakaocup/kakao/progress/PreciseSwipe;", "Landroidx/test/espresso/action/Swiper;", "()V", "DURATION_MS", "", "EVENT_COUNT", "", "TAG", "", "interpolate", "", "", "start", "end", "steps", "([F[FI)[[F", "sendSwipe", "Landroidx/test/espresso/action/Swiper$Status;", "uiController", "Landroidx/test/espresso/UiController;", "startCoordinates", "endCoordinates", "precision", "kakao_release"})
public final class PreciseSwipe
implements Swiper {
    private static final int EVENT_COUNT = 40;
    private static final long DURATION_MS = 1000L;
    private static final String TAG = "PreciseSwipe";
    @NotNull
    public static final PreciseSwipe INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Swiper.Status sendSwipe(@NotNull UiController uiController, @NotNull float[] startCoordinates, @NotNull float[] endCoordinates, @NotNull float[] precision) {
        Intrinsics.checkNotNullParameter((Object)uiController, (String)"uiController");
        Intrinsics.checkNotNullParameter((Object)startCoordinates, (String)"startCoordinates");
        Intrinsics.checkNotNullParameter((Object)endCoordinates, (String)"endCoordinates");
        Intrinsics.checkNotNullParameter((Object)precision, (String)"precision");
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        float[][] steps = this.interpolate(startCoordinates, endCoordinates, 40);
        long delayBetweenMovements = 1000L / (long)((Object[])steps).length;
        MotionEvent downEvent = MotionEvents.sendDown((UiController)uiController, (float[])startCoordinates, (float[])precision).down;
        try {
            int n = 0;
            int n2 = steps.length;
            while (n < n2) {
                void i;
                if (!MotionEvents.sendMovement((UiController)uiController, (MotionEvent)downEvent, (float[])steps[i])) {
                    Log.e((String)TAG, (String)"Injection of move event as part of the swipe failed. Sending cancel event.");
                    MotionEvents.sendCancel((UiController)uiController, (MotionEvent)downEvent);
                    Swiper.Status status = Swiper.Status.FAILURE;
                    return status;
                }
                MotionEvent motionEvent = downEvent;
                Intrinsics.checkNotNullExpressionValue((Object)motionEvent, (String)"downEvent");
                long desiredTime = motionEvent.getDownTime() + delayBetweenMovements * (long)i;
                long timeUntilDesired = desiredTime - SystemClock.uptimeMillis();
                if (timeUntilDesired > (long)10) {
                    uiController.loopMainThreadForAtLeast(timeUntilDesired);
                }
                ++i;
            }
            if (!MotionEvents.sendUp((UiController)uiController, (MotionEvent)downEvent, (float[])endCoordinates)) {
                Log.e((String)TAG, (String)"Injection of up event as part of the swipe failed. Sending cancel event.");
                MotionEvents.sendCancel((UiController)uiController, (MotionEvent)downEvent);
                Swiper.Status status = Swiper.Status.FAILURE;
                return status;
            }
        }
        finally {
            downEvent.recycle();
        }
        return Swiper.Status.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    private final float[][] interpolate(float[] start2, float[] end, int steps) {
        Preconditions.checkElementIndex((int)1, (int)start2.length);
        Preconditions.checkElementIndex((int)1, (int)end.length);
        float[][] fArrayArray = new float[steps][];
        int n = 0;
        while (n < steps) {
            int n2 = n;
            int n3 = n++;
            float[][] fArrayArray2 = fArrayArray;
            boolean bl = false;
            float[] fArray = new float[2];
            fArrayArray2[n3] = fArray;
        }
        float[][] res = fArrayArray;
        int n4 = 1;
        n = steps + 1;
        while (n4 < n) {
            void i;
            res[i - true][0] = start2[0] + (end[0] - start2[0]) * (float)i / ((float)steps + 1.0f);
            res[i - true][1] = start2[1] + (end[1] - start2[1]) * (float)i / ((float)steps + 1.0f);
            ++i;
        }
        return res;
    }

    private PreciseSwipe() {
    }

    static {
        PreciseSwipe preciseSwipe;
        INSTANCE = preciseSwipe = new PreciseSwipe();
    }
}

