/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.recycler;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.contrib.RecyclerViewActions;
import androidx.test.espresso.matcher.ViewMatchers;
import io.github.kakaocup.kakao.common.actions.ScrollableActions;
import io.github.kakaocup.kakao.common.actions.SwipeableActions;
import io.github.kakaocup.kakao.common.builders.ViewBuilder;
import io.github.kakaocup.kakao.delegate.ViewInteractionDelegate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u00012\u00020\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J!\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\b\nH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lio/github/kakaocup/kakao/recycler/RecyclerActions;", "Lio/github/kakaocup/kakao/common/actions/ScrollableActions;", "Lio/github/kakaocup/kakao/common/actions/SwipeableActions;", "getSize", "", "scrollTo", "", "viewBuilder", "Lkotlin/Function1;", "Lio/github/kakaocup/kakao/common/builders/ViewBuilder;", "Lkotlin/ExtensionFunctionType;", "position", "matcher", "Lorg/hamcrest/Matcher;", "Landroid/view/View;", "scrollToEnd", "scrollToStart", "kakao_release"})
public interface RecyclerActions
extends ScrollableActions,
SwipeableActions {
    @Override
    public void scrollToStart();

    @Override
    public void scrollToEnd();

    @Override
    public void scrollTo(int var1);

    public void scrollTo(@NotNull Matcher<View> var1);

    public void scrollTo(@NotNull Function1<? super ViewBuilder, Unit> var1);

    public int getSize();

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void scrollToStart(@NotNull RecyclerActions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAction[] viewActionArray = new ViewAction[1];
            ViewAction viewAction = RecyclerViewActions.scrollToPosition((int)0);
            Intrinsics.checkNotNullExpressionValue((Object)viewAction, (String)"RecyclerViewActions.scro\u2026cyclerView.ViewHolder>(0)");
            viewActionArray[0] = viewAction;
            viewInteractionDelegate.perform(viewActionArray);
        }

        public static void scrollToEnd(@NotNull RecyclerActions $this) {
            $this.getView().perform(new ViewAction(){

                @NotNull
                public String getDescription() {
                    return "Scroll RecyclerView to the bottom";
                }

                public Matcher<View> getConstraints() {
                    return ViewMatchers.isAssignableFrom(RecyclerView.class);
                }

                public void perform(@NotNull UiController controller, @NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    if (view instanceof RecyclerView) {
                        RecyclerView.Adapter adapter = ((RecyclerView)view).getAdapter();
                        Intrinsics.checkNotNull((Object)adapter);
                        Intrinsics.checkNotNullExpressionValue((Object)adapter, (String)"view.adapter!!");
                        int position = adapter.getItemCount() - 1;
                        ((RecyclerView)view).scrollToPosition(position);
                        controller.loopMainThreadUntilIdle();
                        RecyclerView.ViewHolder viewHolder = ((RecyclerView)view).findViewHolderForLayoutPosition(position);
                        Intrinsics.checkNotNull((Object)viewHolder);
                        View view2 = viewHolder.itemView;
                        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewHolderForLa\u2026tion(position)!!.itemView");
                        View lastView = view2;
                        view.scrollBy(0, lastView.getHeight());
                        controller.loopMainThreadUntilIdle();
                    }
                }
            });
        }

        public static void scrollTo(@NotNull RecyclerActions $this, int position) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAction[] viewActionArray = new ViewAction[1];
            ViewAction viewAction = RecyclerViewActions.scrollToPosition((int)position);
            Intrinsics.checkNotNullExpressionValue((Object)viewAction, (String)"RecyclerViewActions.scro\u2026iew.ViewHolder>(position)");
            viewActionArray[0] = viewAction;
            viewInteractionDelegate.perform(viewActionArray);
        }

        public static void scrollTo(@NotNull RecyclerActions $this, @NotNull Matcher<View> matcher) {
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAction[] viewActionArray = new ViewAction[1];
            RecyclerViewActions.PositionableRecyclerViewAction positionableRecyclerViewAction = RecyclerViewActions.scrollTo(matcher);
            Intrinsics.checkNotNullExpressionValue((Object)positionableRecyclerViewAction, (String)"RecyclerViewActions.scro\u2026View.ViewHolder>(matcher)");
            viewActionArray[0] = (ViewAction)positionableRecyclerViewAction;
            viewInteractionDelegate.perform(viewActionArray);
        }

        /*
         * WARNING - void declaration
         */
        public static void scrollTo(@NotNull RecyclerActions $this, @NotNull Function1<? super ViewBuilder, Unit> viewBuilder) {
            void $this$apply;
            Intrinsics.checkNotNullParameter(viewBuilder, (String)"viewBuilder");
            ViewBuilder viewBuilder2 = new ViewBuilder();
            boolean bl = false;
            boolean bl2 = false;
            ViewBuilder viewBuilder3 = viewBuilder2;
            RecyclerActions recyclerActions = $this;
            boolean bl3 = false;
            $this$apply.withIndex(0, viewBuilder);
            Unit unit = Unit.INSTANCE;
            recyclerActions.scrollTo(viewBuilder2.getViewMatcher());
        }

        /*
         * WARNING - void declaration
         */
        public static int getSize(@NotNull RecyclerActions $this) {
            void size;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            $this.getView().perform(new ViewAction((Ref.IntRef)size){
                final /* synthetic */ Ref.IntRef $size;

                @NotNull
                public String getDescription() {
                    return "Get RecyclerView adapter size";
                }

                public Matcher<View> getConstraints() {
                    return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(RecyclerView.class), (Matcher)ViewMatchers.isDisplayed());
                }

                public void perform(@Nullable UiController uiController, @Nullable View view) {
                    if (view instanceof RecyclerView) {
                        RecyclerView.Adapter adapter = ((RecyclerView)view).getAdapter();
                        Integer n = adapter != null ? Integer.valueOf(adapter.getItemCount()) : null;
                        Intrinsics.checkNotNull((Object)n);
                        this.$size.element = n;
                    }
                }
                {
                    this.$size = $captured_local_variable$0;
                }
            });
            return size.element;
        }

        public static void scrollTo(@NotNull RecyclerActions $this) {
            ScrollableActions.DefaultImpls.scrollTo($this);
        }

        public static void click(@NotNull RecyclerActions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.click($this, location);
        }

        public static void doubleClick(@NotNull RecyclerActions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.doubleClick($this, location);
        }

        public static void longClick(@NotNull RecyclerActions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.longClick($this, location);
        }

        public static void pressImeAction(@NotNull RecyclerActions $this) {
            ScrollableActions.DefaultImpls.pressImeAction($this);
        }

        public static void act(@NotNull RecyclerActions $this, @NotNull Function0<? extends ViewAction> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            ScrollableActions.DefaultImpls.act($this, function);
        }

        public static void onFailure(@NotNull RecyclerActions $this, @NotNull Function2<? super Throwable, ? super Matcher<View>, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            ScrollableActions.DefaultImpls.onFailure($this, function);
        }

        public static void repeatUntil(@NotNull RecyclerActions $this, int maxAttempts, @NotNull Function0<? extends ViewAction> action2, @NotNull Function1<? super ViewBuilder, Unit> matcher) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            ScrollableActions.DefaultImpls.repeatUntil($this, maxAttempts, action2, matcher);
        }

        public static void swipeLeft(@NotNull RecyclerActions $this) {
            SwipeableActions.DefaultImpls.swipeLeft($this);
        }

        public static void swipeRight(@NotNull RecyclerActions $this) {
            SwipeableActions.DefaultImpls.swipeRight($this);
        }

        public static void swipeUp(@NotNull RecyclerActions $this) {
            SwipeableActions.DefaultImpls.swipeUp($this);
        }

        public static void swipeDown(@NotNull RecyclerActions $this) {
            SwipeableActions.DefaultImpls.swipeDown($this);
        }
    }
}

