/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.scroll;

import android.view.View;
import android.widget.ScrollView;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.matcher.ViewMatchers;
import io.github.kakaocup.kakao.common.actions.ScrollableActions;
import io.github.kakaocup.kakao.common.actions.SwipeableActions;
import io.github.kakaocup.kakao.common.builders.ViewBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lio/github/kakaocup/kakao/scroll/ScrollViewActions;", "Lio/github/kakaocup/kakao/common/actions/ScrollableActions;", "Lio/github/kakaocup/kakao/common/actions/SwipeableActions;", "scrollTo", "", "position", "", "scrollToEnd", "scrollToStart", "kakao_release"})
public interface ScrollViewActions
extends ScrollableActions,
SwipeableActions {
    @Override
    public void scrollToStart();

    @Override
    public void scrollToEnd();

    @Override
    public void scrollTo(int var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void scrollToStart(@NotNull ScrollViewActions $this) {
            $this.getView().perform(new ViewAction(){

                @NotNull
                public String getDescription() {
                    return "Scroll ScrollView to start";
                }

                public Matcher<View> getConstraints() {
                    return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(ScrollView.class), (Matcher)ViewMatchers.isDisplayed());
                }

                public void perform(@Nullable UiController uiController, @Nullable View view) {
                    if (view instanceof ScrollView) {
                        ((ScrollView)view).fullScroll(33);
                    }
                }
            });
        }

        public static void scrollToEnd(@NotNull ScrollViewActions $this) {
            $this.getView().perform(new ViewAction(){

                @NotNull
                public String getDescription() {
                    return "Scroll ScrollView to end";
                }

                public Matcher<View> getConstraints() {
                    return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(ScrollView.class), (Matcher)ViewMatchers.isDisplayed());
                }

                public void perform(@Nullable UiController uiController, @Nullable View view) {
                    if (view instanceof ScrollView) {
                        ((ScrollView)view).fullScroll(130);
                    }
                }
            });
        }

        public static void scrollTo(@NotNull ScrollViewActions $this, int position) {
            $this.getView().perform(new ViewAction(position){
                final /* synthetic */ int $position;

                @NotNull
                public String getDescription() {
                    return "Scroll ScrollView to " + this.$position + " Y position";
                }

                public Matcher<View> getConstraints() {
                    return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(ScrollView.class), (Matcher)ViewMatchers.isDisplayed());
                }

                public void perform(@Nullable UiController uiController, @Nullable View view) {
                    if (view instanceof ScrollView) {
                        view.scrollTo(0, this.$position);
                    }
                }
                {
                    this.$position = $captured_local_variable$0;
                }
            });
        }

        public static void scrollTo(@NotNull ScrollViewActions $this) {
            ScrollableActions.DefaultImpls.scrollTo($this);
        }

        public static void click(@NotNull ScrollViewActions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.click($this, location);
        }

        public static void doubleClick(@NotNull ScrollViewActions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.doubleClick($this, location);
        }

        public static void longClick(@NotNull ScrollViewActions $this, @NotNull GeneralLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ScrollableActions.DefaultImpls.longClick($this, location);
        }

        public static void pressImeAction(@NotNull ScrollViewActions $this) {
            ScrollableActions.DefaultImpls.pressImeAction($this);
        }

        public static void act(@NotNull ScrollViewActions $this, @NotNull Function0<? extends ViewAction> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            ScrollableActions.DefaultImpls.act($this, function);
        }

        public static void onFailure(@NotNull ScrollViewActions $this, @NotNull Function2<? super Throwable, ? super Matcher<View>, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            ScrollableActions.DefaultImpls.onFailure($this, function);
        }

        public static void repeatUntil(@NotNull ScrollViewActions $this, int maxAttempts, @NotNull Function0<? extends ViewAction> action2, @NotNull Function1<? super ViewBuilder, Unit> matcher) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            ScrollableActions.DefaultImpls.repeatUntil($this, maxAttempts, action2, matcher);
        }

        public static void swipeLeft(@NotNull ScrollViewActions $this) {
            SwipeableActions.DefaultImpls.swipeLeft($this);
        }

        public static void swipeRight(@NotNull ScrollViewActions $this) {
            SwipeableActions.DefaultImpls.swipeRight($this);
        }

        public static void swipeUp(@NotNull ScrollViewActions $this) {
            SwipeableActions.DefaultImpls.swipeUp($this);
        }

        public static void swipeDown(@NotNull ScrollViewActions $this) {
            SwipeableActions.DefaultImpls.swipeDown($this);
        }
    }
}

