/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.searchview;

import android.view.View;
import android.widget.SearchView;
import androidx.annotation.ColorRes;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.test.espresso.ViewAssertion;
import io.github.kakaocup.kakao.common.assertions.BaseAssertions;
import io.github.kakaocup.kakao.common.builders.RootBuilder;
import io.github.kakaocup.kakao.common.builders.ViewBuilder;
import io.github.kakaocup.kakao.common.utilities.ContextUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lio/github/kakaocup/kakao/searchview/SearchViewAssertions;", "Lio/github/kakaocup/kakao/common/assertions/BaseAssertions;", "hasHint", "Lorg/hamcrest/Matcher;", "Landroid/view/View;", "queryHintId", "", "hint", "", "hasQuery", "query", "kakao_release"})
@RequiresApi(value=16)
public interface SearchViewAssertions
extends BaseAssertions {
    @NotNull
    public Matcher<View> hasHint(@NotNull String var1);

    @NotNull
    public Matcher<View> hasHint(@StringRes int var1);

    @NotNull
    public Matcher<View> hasQuery(@NotNull String var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Matcher<View> hasHint(@NotNull SearchViewAssertions $this, @NotNull String hint) {
            Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
            return (Matcher)new Matcher<View>(hint, SearchView.class){
                @Nullable
                private String realHint;
                final /* synthetic */ String $hint;

                @Nullable
                public final String getRealHint() {
                    return this.realHint;
                }

                public final void setRealHint(@Nullable String string) {
                    this.realHint = string;
                }

                public void describeTo(@NotNull Description description) {
                    Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                    description.appendText("with SearchView hint: " + this.$hint + ", but was: " + this.realHint);
                }

                protected boolean matchesSafely(@NotNull SearchView item) {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    CharSequence charSequence = item.getQueryHint();
                    return Intrinsics.areEqual((Object)(charSequence != null ? ((Object)charSequence).toString() : null), (Object)this.$hint);
                }
                {
                    this.$hint = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            };
        }

        @NotNull
        public static Matcher<View> hasHint(@NotNull SearchViewAssertions $this, @StringRes int queryHintId) {
            return $this.hasHint(ContextUtilsKt.getResourceString(queryHintId));
        }

        @NotNull
        public static Matcher<View> hasQuery(@NotNull SearchViewAssertions $this, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return (Matcher)new Matcher<View>(query, SearchView.class){
                @Nullable
                private String foundQuery;
                final /* synthetic */ String $query;

                @Nullable
                public final String getFoundQuery() {
                    return this.foundQuery;
                }

                public final void setFoundQuery(@Nullable String string) {
                    this.foundQuery = string;
                }

                public void describeTo(@NotNull Description description) {
                    Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                    description.appendText("with SearchView query: " + this.$query + ", but was: " + this.foundQuery);
                }

                protected boolean matchesSafely(@NotNull SearchView item) {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    this.foundQuery = ((Object)item.getQuery()).toString();
                    return Intrinsics.areEqual((Object)this.foundQuery, (Object)this.$query);
                }
                {
                    this.$query = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            };
        }

        public static void isDisplayed(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isDisplayed($this);
        }

        public static void isNotDisplayed(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotDisplayed($this);
        }

        public static void isCompletelyDisplayed(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isCompletelyDisplayed($this);
        }

        public static void isNotCompletelyDisplayed(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotCompletelyDisplayed($this);
        }

        public static void isVisible(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isVisible($this);
        }

        public static void isInvisible(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isInvisible($this);
        }

        public static void isGone(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isGone($this);
        }

        public static void isSelected(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isSelected($this);
        }

        public static void isNotSelected(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotSelected($this);
        }

        public static void isFocused(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isFocused($this);
        }

        public static void isNotFocused(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocused($this);
        }

        public static void isFocusable(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isFocusable($this);
        }

        public static void isNotFocusable(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocusable($this);
        }

        public static void isClickable(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isClickable($this);
        }

        public static void isNotClickable(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotClickable($this);
        }

        public static void isEnabled(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isEnabled($this);
        }

        public static void isDisabled(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.isDisabled($this);
        }

        public static void hasTag(@NotNull SearchViewAssertions $this, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            BaseAssertions.DefaultImpls.hasTag($this, tag);
        }

        public static void hasAnyTag(@NotNull SearchViewAssertions $this, String ... tags) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            BaseAssertions.DefaultImpls.hasAnyTag($this, tags);
        }

        public static void doesNotExist(@NotNull SearchViewAssertions $this) {
            BaseAssertions.DefaultImpls.doesNotExist($this);
        }

        public static void hasDescendant(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasDescendant($this, function);
        }

        public static void hasNotDescendant(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotDescendant($this, function);
        }

        public static void hasSibling(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasSibling($this, function);
        }

        public static void hasNotSibling(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotSibling($this, function);
        }

        public static void matches(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.matches($this, function);
        }

        public static void notMatches(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.notMatches($this, function);
        }

        public static void assert(@NotNull SearchViewAssertions $this, @NotNull Function0<? extends ViewAssertion> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.assert($this, function);
        }

        public static void inRoot(@NotNull SearchViewAssertions $this, @NotNull Function1<? super RootBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.inRoot($this, function);
        }

        public static void hasBackgroundColor(@NotNull SearchViewAssertions $this, @ColorRes int resId) {
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, resId);
        }

        public static void hasBackgroundColor(@NotNull SearchViewAssertions $this, @NotNull String colorCode) {
            Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, colorCode);
        }

        public static void isCompletelyAbove(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyAbove($this, function);
        }

        public static void isCompletelyBelow(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyBelow($this, function);
        }

        public static void isCompletelyLeftOf(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyLeftOf($this, function);
        }

        public static void isCompletelyRightOf(@NotNull SearchViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyRightOf($this, function);
        }
    }
}

