/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.text;

import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.assertion.ViewAssertions;
import androidx.test.espresso.matcher.ViewMatchers;
import io.github.kakaocup.kakao.common.assertions.BaseAssertions;
import io.github.kakaocup.kakao.common.builders.RootBuilder;
import io.github.kakaocup.kakao.common.builders.ViewBuilder;
import io.github.kakaocup.kakao.common.matchers.AnyTextMatcher;
import io.github.kakaocup.kakao.delegate.ViewInteractionDelegate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0012\u0010\t\u001a\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0012\u0010\r\u001a\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u000e\u001a\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0013"}, d2={"Lio/github/kakaocup/kakao/text/TextViewAssertions;", "Lio/github/kakaocup/kakao/common/assertions/BaseAssertions;", "containsText", "", "text", "", "hasAnyText", "hasContentDescription", "hasEmptyText", "hasHint", "resId", "", "hint", "hasNoText", "hasText", "matcher", "Lorg/hamcrest/Matcher;", "hasTextColor", "startsWithText", "kakao_release"})
public interface TextViewAssertions
extends BaseAssertions {
    public void hasEmptyText();

    public void hasAnyText();

    public void hasText(@NotNull String var1);

    public void hasText(@StringRes int var1);

    public void hasText(@NotNull Matcher<String> var1);

    public void hasTextColor(@ColorRes int var1);

    public void hasNoText(@NotNull String var1);

    public void hasNoText(@StringRes int var1);

    public void hasContentDescription(@NotNull String var1);

    public void containsText(@NotNull String var1);

    public void startsWithText(@NotNull String var1);

    public void hasHint(@NotNull String var1);

    public void hasHint(@StringRes int var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void hasEmptyText(@NotNull TextViewAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withText((String)""));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026ithText(\"\")\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasAnyText(@NotNull TextViewAssertions $this) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new AnyTextMatcher()));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026xtMatcher()\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasText(@NotNull TextViewAssertions $this, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withText((String)text2));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026hText(text)\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasText(@NotNull TextViewAssertions $this, @StringRes int resId) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withText((int)resId));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026Text(resId)\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasText(@NotNull TextViewAssertions $this, @NotNull Matcher<String> matcher) {
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withText(matcher));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026xt(matcher)\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasTextColor(@NotNull TextViewAssertions $this, @ColorRes int resId) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.hasTextColor((int)resId));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026olor(resId)\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasNoText(@NotNull TextViewAssertions $this, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)CoreMatchers.not((Matcher)ViewMatchers.withText((String)text2)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026          )\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasNoText(@NotNull TextViewAssertions $this, @StringRes int resId) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)CoreMatchers.not((Matcher)ViewMatchers.withText((int)resId)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026          )\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasContentDescription(@NotNull TextViewAssertions $this, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withContentDescription((String)text2));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(V\u2026ContentDescription(text))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void containsText(@NotNull TextViewAssertions $this, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withText((Matcher)Matchers.containsString((String)text2)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026ring(text))\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void startsWithText(@NotNull TextViewAssertions $this, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withText((Matcher)Matchers.startsWith((String)text2)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026With(text))\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasHint(@NotNull TextViewAssertions $this, @NotNull String hint) {
            Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withHint((String)hint));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026hHint(hint)\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasHint(@NotNull TextViewAssertions $this, @StringRes int resId) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)ViewMatchers.withHint((int)resId));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(\n\u2026Hint(resId)\n            )");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void isDisplayed(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isDisplayed($this);
        }

        public static void isNotDisplayed(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotDisplayed($this);
        }

        public static void isCompletelyDisplayed(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isCompletelyDisplayed($this);
        }

        public static void isNotCompletelyDisplayed(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotCompletelyDisplayed($this);
        }

        public static void isVisible(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isVisible($this);
        }

        public static void isInvisible(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isInvisible($this);
        }

        public static void isGone(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isGone($this);
        }

        public static void isSelected(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isSelected($this);
        }

        public static void isNotSelected(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotSelected($this);
        }

        public static void isFocused(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isFocused($this);
        }

        public static void isNotFocused(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocused($this);
        }

        public static void isFocusable(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isFocusable($this);
        }

        public static void isNotFocusable(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocusable($this);
        }

        public static void isClickable(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isClickable($this);
        }

        public static void isNotClickable(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotClickable($this);
        }

        public static void isEnabled(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isEnabled($this);
        }

        public static void isDisabled(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.isDisabled($this);
        }

        public static void hasTag(@NotNull TextViewAssertions $this, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            BaseAssertions.DefaultImpls.hasTag($this, tag);
        }

        public static void hasAnyTag(@NotNull TextViewAssertions $this, String ... tags) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            BaseAssertions.DefaultImpls.hasAnyTag($this, tags);
        }

        public static void doesNotExist(@NotNull TextViewAssertions $this) {
            BaseAssertions.DefaultImpls.doesNotExist($this);
        }

        public static void hasDescendant(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasDescendant($this, function);
        }

        public static void hasNotDescendant(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotDescendant($this, function);
        }

        public static void hasSibling(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasSibling($this, function);
        }

        public static void hasNotSibling(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotSibling($this, function);
        }

        public static void matches(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.matches($this, function);
        }

        public static void notMatches(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.notMatches($this, function);
        }

        public static void assert(@NotNull TextViewAssertions $this, @NotNull Function0<? extends ViewAssertion> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.assert($this, function);
        }

        public static void inRoot(@NotNull TextViewAssertions $this, @NotNull Function1<? super RootBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.inRoot($this, function);
        }

        public static void hasBackgroundColor(@NotNull TextViewAssertions $this, @ColorRes int resId) {
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, resId);
        }

        public static void hasBackgroundColor(@NotNull TextViewAssertions $this, @NotNull String colorCode) {
            Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, colorCode);
        }

        public static void isCompletelyAbove(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyAbove($this, function);
        }

        public static void isCompletelyBelow(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyBelow($this, function);
        }

        public static void isCompletelyLeftOf(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyLeftOf($this, function);
        }

        public static void isCompletelyRightOf(@NotNull TextViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyRightOf($this, function);
        }
    }
}

