/*
 * Decompiled with CFR 0.152.
 */
package io.github.kakaocup.kakao.toolbar;

import android.graphics.drawable.Drawable;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.assertion.ViewAssertions;
import io.github.kakaocup.kakao.common.assertions.BaseAssertions;
import io.github.kakaocup.kakao.common.builders.RootBuilder;
import io.github.kakaocup.kakao.common.builders.ViewBuilder;
import io.github.kakaocup.kakao.common.matchers.ToolbarNavigationMatcher;
import io.github.kakaocup.kakao.common.matchers.ToolbarSubtitleMatcher;
import io.github.kakaocup.kakao.common.matchers.ToolbarTitleMatcher;
import io.github.kakaocup.kakao.delegate.ViewInteractionDelegate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lio/github/kakaocup/kakao/toolbar/ToolbarViewAssertions;", "Lio/github/kakaocup/kakao/common/assertions/BaseAssertions;", "hasHomeAsUpIndicatorDrawable", "", "drawable", "Landroid/graphics/drawable/Drawable;", "resId", "", "hasSubtitle", "subtitle", "", "hasTitle", "title", "kakao_release"})
public interface ToolbarViewAssertions
extends BaseAssertions {
    public void hasTitle(@NotNull String var1);

    public void hasSubtitle(@NotNull String var1);

    public void hasTitle(int var1);

    public void hasSubtitle(int var1);

    public void hasHomeAsUpIndicatorDrawable(@DrawableRes int var1);

    public void hasHomeAsUpIndicatorDrawable(@NotNull Drawable var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void hasTitle(@NotNull ToolbarViewAssertions $this, @NotNull String title2) {
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new ToolbarTitleMatcher(title2)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(ToolbarTitleMatcher(title))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasSubtitle(@NotNull ToolbarViewAssertions $this, @NotNull String subtitle) {
            Intrinsics.checkNotNullParameter((Object)subtitle, (String)"subtitle");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new ToolbarSubtitleMatcher(subtitle)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026ubtitleMatcher(subtitle))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasTitle(@NotNull ToolbarViewAssertions $this, int resId) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new ToolbarTitleMatcher(resId)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(ToolbarTitleMatcher(resId))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasSubtitle(@NotNull ToolbarViewAssertions $this, int resId) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new ToolbarSubtitleMatcher(resId)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026arSubtitleMatcher(resId))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasHomeAsUpIndicatorDrawable(@NotNull ToolbarViewAssertions $this, @DrawableRes int resId) {
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new ToolbarNavigationMatcher(resId)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026NavigationMatcher(resId))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void hasHomeAsUpIndicatorDrawable(@NotNull ToolbarViewAssertions $this, @NotNull Drawable drawable) {
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            ViewInteractionDelegate viewInteractionDelegate = $this.getView();
            ViewAssertion viewAssertion = ViewAssertions.matches((Matcher)((Matcher)new ToolbarNavigationMatcher(drawable)));
            Intrinsics.checkNotNullExpressionValue((Object)viewAssertion, (String)"ViewAssertions.matches(T\u2026igationMatcher(drawable))");
            viewInteractionDelegate.check(viewAssertion);
        }

        public static void isDisplayed(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isDisplayed($this);
        }

        public static void isNotDisplayed(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotDisplayed($this);
        }

        public static void isCompletelyDisplayed(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isCompletelyDisplayed($this);
        }

        public static void isNotCompletelyDisplayed(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotCompletelyDisplayed($this);
        }

        public static void isVisible(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isVisible($this);
        }

        public static void isInvisible(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isInvisible($this);
        }

        public static void isGone(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isGone($this);
        }

        public static void isSelected(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isSelected($this);
        }

        public static void isNotSelected(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotSelected($this);
        }

        public static void isFocused(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isFocused($this);
        }

        public static void isNotFocused(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocused($this);
        }

        public static void isFocusable(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isFocusable($this);
        }

        public static void isNotFocusable(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotFocusable($this);
        }

        public static void isClickable(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isClickable($this);
        }

        public static void isNotClickable(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isNotClickable($this);
        }

        public static void isEnabled(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isEnabled($this);
        }

        public static void isDisabled(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.isDisabled($this);
        }

        public static void hasTag(@NotNull ToolbarViewAssertions $this, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            BaseAssertions.DefaultImpls.hasTag($this, tag);
        }

        public static void hasAnyTag(@NotNull ToolbarViewAssertions $this, String ... tags) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            BaseAssertions.DefaultImpls.hasAnyTag($this, tags);
        }

        public static void doesNotExist(@NotNull ToolbarViewAssertions $this) {
            BaseAssertions.DefaultImpls.doesNotExist($this);
        }

        public static void hasDescendant(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasDescendant($this, function);
        }

        public static void hasNotDescendant(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotDescendant($this, function);
        }

        public static void hasSibling(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasSibling($this, function);
        }

        public static void hasNotSibling(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.hasNotSibling($this, function);
        }

        public static void matches(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.matches($this, function);
        }

        public static void notMatches(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.notMatches($this, function);
        }

        public static void assert(@NotNull ToolbarViewAssertions $this, @NotNull Function0<? extends ViewAssertion> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.assert($this, function);
        }

        public static void inRoot(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super RootBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.inRoot($this, function);
        }

        public static void hasBackgroundColor(@NotNull ToolbarViewAssertions $this, @ColorRes int resId) {
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, resId);
        }

        public static void hasBackgroundColor(@NotNull ToolbarViewAssertions $this, @NotNull String colorCode) {
            Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
            BaseAssertions.DefaultImpls.hasBackgroundColor((BaseAssertions)$this, colorCode);
        }

        public static void isCompletelyAbove(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyAbove($this, function);
        }

        public static void isCompletelyBelow(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyBelow($this, function);
        }

        public static void isCompletelyLeftOf(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyLeftOf($this, function);
        }

        public static void isCompletelyRightOf(@NotNull ToolbarViewAssertions $this, @NotNull Function1<? super ViewBuilder, Unit> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            BaseAssertions.DefaultImpls.isCompletelyRightOf($this, function);
        }
    }
}

