/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.caller;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;

public class ReflectionHelper {
    private static final ConcurrentLinkedQueue<ClassStatusChecker> checkers = new ConcurrentLinkedQueue();
    private static final BiFunction<ClassStatusChecker, Object, ClassStatus> VC_CHECK_CLASS_NAME = (c, n) -> c.checkClassName((String)n);
    private static final BiFunction<ClassStatusChecker, Object, ClassStatus> VC_CHECK_CLASS = (c, cl) -> c.checkClass((Class)cl);

    public static void registerChecker(ClassStatusChecker checker) {
        if (checker != null) {
            checkers.add(checker);
        }
    }

    public static void unregister(ClassStatusChecker checker) {
        if (checker != null) {
            checkers.remove(checker);
        }
    }

    private static boolean isReflectionClass(BiFunction<ClassStatusChecker, Object, ClassStatus> tester, Object handle) {
        for (ClassStatusChecker checker : checkers) {
            ClassStatus status = tester.apply(checker, handle);
            if (status == null || status == ClassStatus.UNKNOWN) continue;
            return status.asBoolean();
        }
        return false;
    }

    public static boolean isReflectionClass(Class<?> klass) {
        return ReflectionHelper.isReflectionClass(VC_CHECK_CLASS, klass);
    }

    public static boolean isReflectionClass(String klass) {
        return ReflectionHelper.isReflectionClass(VC_CHECK_CLASS_NAME, klass);
    }

    public static boolean isNotReflectionClass(Class<?> klass) {
        return !ReflectionHelper.isReflectionClass(VC_CHECK_CLASS, klass);
    }

    public static boolean isNotReflectionClass(String klass) {
        return !ReflectionHelper.isReflectionClass(VC_CHECK_CLASS_NAME, klass);
    }

    static {
        ReflectionHelper.registerChecker(name -> {
            if (name.indexOf(47) > 0) {
                return ClassStatus.REFLECTION_CLASS;
            }
            return ClassStatus.UNKNOWN;
        });
        ReflectionHelper.registerChecker(name -> {
            if (name.startsWith("jdk.internal.reflect.") || name.startsWith("sun.reflect.") || name.startsWith("java.lang.reflect.")) {
                return ClassStatus.REFLECTION_CLASS;
            }
            return ClassStatus.UNKNOWN;
        });
        HashSet<String> kotlinReflection = new HashSet<String>(Arrays.asList("kotlin.jvm.internal.CallableReference", "kotlin.jvm.internal.FunctionReference", "kotlin.jvm.internal.FunctionReferenceImpl"));
        ReflectionHelper.registerChecker(name -> {
            if (name.startsWith("kotlin.reflect.") || kotlinReflection.contains(name)) {
                return ClassStatus.REFLECTION_CLASS;
            }
            return ClassStatus.UNKNOWN;
        });
    }

    public static interface ClassStatusChecker {
        public ClassStatus checkClassName(String var1);

        default public ClassStatus checkClass(Class<?> klass) {
            return this.checkClassName(klass.getName());
        }
    }

    public static enum ClassStatus {
        UNKNOWN(false),
        REFLECTION_CLASS(true),
        STANDARD_CLASS(false);

        private final boolean asBoolean;

        private ClassStatus(boolean asBoolean) {
            this.asBoolean = asBoolean;
        }

        public boolean asBoolean() {
            return this.asBoolean;
        }
    }
}

