/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.unsafeaccessor;

import io.github.karlatemp.unsafeaccessor.ProtectedObject;
import java.security.Permission;

public final class SecurityCheck
extends ProtectedObject {
    static final SecurityCheck INSTANCE = new SecurityCheck();
    static Permission PERMISSION_GET_UNSAFE;
    static Permission PERMISSION_OPEN_ACCESS;

    SecurityCheck() {
        this.trusted = true;
    }

    public static SecurityCheck getInstance() {
        SecurityManager sm;
        Permission p = PERMISSION_GET_UNSAFE;
        if (p != null && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(p);
        }
        return INSTANCE;
    }

    public Permission getPermission() {
        this.checkTrusted();
        return PERMISSION_GET_UNSAFE;
    }

    public Permission getPermissionOpenAccess() {
        this.checkTrusted();
        return PERMISSION_OPEN_ACCESS;
    }

    public void setPermissionOpenAccess(Permission permissionOpenAccess) {
        this.checkTrusted();
        PERMISSION_OPEN_ACCESS = permissionOpenAccess;
    }

    public void setPermission(Permission permission) {
        this.checkTrusted();
        PERMISSION_GET_UNSAFE = permission;
    }

    public void enableSecurityCheck() {
        this.checkTrusted();
        this.setPermission(new RuntimePermission("unsafe.getInstance"));
    }
}

