/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.unsafeaccessor;

import io.github.karlatemp.unsafeaccessor.ModuleAccess;
import io.github.karlatemp.unsafeaccessor.ProtectedObject;
import io.github.karlatemp.unsafeaccessor.Root;
import io.github.karlatemp.unsafeaccessor.SecurityCheck;
import io.github.karlatemp.unsafeaccessor.Unsafe;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;

public final class UnsafeAccess
extends ProtectedObject {
    static final UnsafeAccess INSTANCE = new UnsafeAccess();

    public static UnsafeAccess getInstance() {
        SecurityCheck.getInstance();
        return INSTANCE;
    }

    public SecurityCheck getSecuritySettings() {
        this.checkTrusted();
        return SecurityCheck.INSTANCE;
    }

    public Unsafe getUnsafe() {
        this.checkTrusted();
        return Unsafe.getUnsafe0();
    }

    @Deprecated
    public MethodHandles.Lookup getTrusted() {
        this.checkTrusted();
        return Root.RootLookupHolder.ROOT;
    }

    public MethodHandles.Lookup getTrustedIn(Class<?> target) {
        this.checkTrusted();
        return Root.RootLookupHolder.trustedIn(target);
    }

    public <T extends AccessibleObject> T openAccess(T object) {
        this.checkTrusted();
        Root.OpenAccess.openAccess0(object, true);
        return object;
    }

    public <T extends AccessibleObject> T setAccessible(T object, boolean accessible) {
        this.checkTrusted();
        Root.OpenAccess.openAccess0(object, accessible);
        return object;
    }

    public ModuleAccess getModuleAccess() {
        this.checkTrusted();
        Unsafe.getUnsafe0();
        return Root.Secret.MACCESS;
    }
}

