/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.unsafeaccessor;

import io.github.karlatemp.unsafeaccessor.MHLookup;
import io.github.karlatemp.unsafeaccessor.ModuleAccess;
import io.github.karlatemp.unsafeaccessor.SecurityCheck;
import io.github.karlatemp.unsafeaccessor.Unsafe;
import io.github.karlatemp.unsafeaccessor.UnsafeAccess;
import io.github.karlatemp.unsafeaccessor.UsfAccessor;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;

public class Root {
    @Contract(pure=false)
    public static Unsafe getUnsafe() {
        return Unsafe.getUnsafe();
    }

    @Deprecated
    @Contract(pure=true)
    public static MethodHandles.Lookup getTrusted() {
        SecurityCheck.LIMITER.preGetTrustedLookup(null);
        return RootLookupHolder.ROOT;
    }

    @Contract(pure=true)
    public static MethodHandles.Lookup getTrusted(Class<?> k) {
        SecurityCheck.LIMITER.preGetTrustedLookup(k);
        return RootLookupHolder.trustedIn(k);
    }

    @Contract(pure=false, value="null, _ -> fail")
    public static void setAccessible(AccessibleObject object, boolean isAccessible) {
        OpenAccess.openAccess(object, isAccessible);
    }

    @Contract(pure=false, value="null -> fail")
    public static <T extends AccessibleObject> T openAccess(T object) {
        Root.setAccessible(object, true);
        return object;
    }

    @Contract(pure=false)
    public static <T> T throw0(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        Unsafe.getUnsafe0().throwException(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(pure=false)
    public static <T> T allocate(Class<T> klass) throws InstantiationException {
        return (T)Root.getUnsafe().allocateInstance(klass);
    }

    @Contract(pure=true)
    public static ModuleAccess getModuleAccess() {
        Root.getUnsafe();
        return Secret.MACCESS;
    }

    public static void initializeObject(Object instance) {
        if (instance == null) {
            return;
        }
        Unsafe.getUnsafe0().ensureClassInitialized(instance.getClass());
        ObjectInitializer.initializer().accept(instance);
    }

    static class RootLookupHolder {
        static final MethodHandles.Lookup ROOT;
        static final boolean isOpenj9;
        static final long accessMode;

        RootLookupHolder() {
        }

        static boolean isOpenJ9vm() {
            if (ROOT.lookupClass() == MethodHandle.class) {
                int modes = ROOT.lookupModes();
                return modes == 64 || modes == 128;
            }
            return false;
        }

        static MethodHandles.Lookup trustedIn(Class<?> target) {
            if (target == null) {
                return ROOT;
            }
            if (isOpenj9) {
                MethodHandles.Lookup lookup = ROOT.in(target);
                Unsafe.getUnsafe0().putLong(lookup, accessMode, ROOT.lookupModes());
                return lookup;
            }
            return ROOT;
        }

        static {
            try {
                MethodHandles.Lookup lookup;
                Unsafe unsafe = Root.getUnsafe();
                try {
                    Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                    Root.openAccess(field);
                    lookup = (MethodHandles.Lookup)field.get(null);
                }
                catch (Throwable any) {
                    if (unsafe.isJava9()) {
                        lookup = MethodHandles.lookup();
                        unsafe.putReference(lookup, unsafe.objectFieldOffset(MethodHandles.Lookup.class, "lookupClass"), Object.class);
                        unsafe.putInt(lookup, unsafe.objectFieldOffset(MethodHandles.Lookup.class, "allowedModes"), -1);
                    }
                    throw any;
                }
                ROOT = lookup;
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
            isOpenj9 = RootLookupHolder.isOpenJ9vm();
            accessMode = isOpenj9 ? Unsafe.getUnsafe0().objectFieldOffset(MethodHandles.Lookup.class, "accessMode") : -1L;
        }
    }

    static class OpenAccess {
        private static final Unsafe usf = Unsafe.getUnsafe0();
        private static final long overrideOffset;

        OpenAccess() {
        }

        static void openAccess0(AccessibleObject object, boolean isAccessible) {
            if (object == null) {
                throw new NullPointerException("object");
            }
            usf.putBoolean(object, overrideOffset, isAccessible);
        }

        static void openAccess(AccessibleObject object, boolean isAccessible) {
            if (isAccessible) {
                SecurityCheck.LIMITER.preOpenAccessible(object);
            }
            OpenAccess.openAccess0(object, isAccessible);
        }

        static {
            if (usf.isJava9()) {
                overrideOffset = usf.objectFieldOffset(AccessibleObject.class, "override");
            } else {
                try {
                    Field field = AccessibleObject.class.getDeclaredField("override");
                    overrideOffset = usf.objectFieldOffset(field);
                }
                catch (Throwable throwable) {
                    throw new ExceptionInInitializerError(throwable);
                }
            }
        }
    }

    static class Secret {
        static ModuleAccess MACCESS;

        Secret() {
        }
    }

    static class ObjectInitializer {
        static Consumer<Object> initializer;

        ObjectInitializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Consumer<Object> initializer() {
            if (initializer != null) {
                return initializer;
            }
            Class<ObjectInitializer> clazz = ObjectInitializer.class;
            synchronized (ObjectInitializer.class) {
                if (initializer != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return initializer;
                }
                initializer = UsfAccessor.allocateObjectInitializer();
                // ** MonitorExit[var0] (shouldn't be in output)
                return initializer;
            }
        }
    }

    public static class MethodHandleLookup {
        private static void checkAccess(UnsafeAccess access) {
            if (access == null) {
                Root.getUnsafe();
            } else {
                access.checkTrusted();
            }
        }

        public static MethodHandle lookup(UnsafeAccess access, String methodName, MethodType methodType) throws NoSuchMethodException {
            return MethodHandleLookup.lookup(access, methodName, methodType, false, true);
        }

        public static MethodHandle lookup(UnsafeAccess access, String methodName, MethodType methodType, boolean lookupDirect, boolean doBind) throws NoSuchMethodException {
            MethodHandleLookup.checkAccess(access);
            if (lookupDirect) {
                return MHLookup.lookupDirect(methodName, methodType, doBind);
            }
            return MHLookup.lookup(methodName, methodType, doBind ? null : new Object[1]);
        }

        private static UnsafeAccess detectUnsafeAccessHold(MethodHandles.Lookup lookup, MethodHandle mh) {
            if (mh != null) {
                if (mh.type().parameterCount() != 0) {
                    throw new IllegalArgumentException("parameters not empty: " + mh);
                }
                if (mh.type().returnType() != UnsafeAccess.class) {
                    throw new IllegalArgumentException("Provided method handle is not a access check handle.");
                }
                try {
                    return mh.invokeExact();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable2) {
                    throw new InternalError(throwable2);
                }
            }
            if (lookup == null) {
                return null;
            }
            if (lookup == MethodHandles.publicLookup()) {
                return null;
            }
            try {
                try {
                    return MethodHandleLookup.detectUnsafeAccessHold(null, lookup.findStaticGetter(lookup.lookupClass(), "UA", UnsafeAccess.class));
                }
                catch (NoSuchFieldException throwable2) {
                    try {
                        return MethodHandleLookup.detectUnsafeAccessHold(null, lookup.findStaticGetter(lookup.lookupClass(), "UNSAFE_ACCESS", UnsafeAccess.class));
                    }
                    catch (NoSuchFieldException throwable2) {
                    }
                }
            }
            catch (IllegalAccessException ignored) {
                throw new IllegalArgumentException("Provided caller <" + lookup + "> have no full access for itself");
            }
            return null;
        }

        public static CallSite resolveHandle(MethodHandles.Lookup caller, String methodName, MethodType methodType) throws NoSuchMethodException {
            return MethodHandleLookup.resolve(caller, methodName, methodType, 0, null);
        }

        public static CallSite resolveHandleDirect(MethodHandles.Lookup caller, String methodName, MethodType methodType) throws NoSuchMethodException {
            return MethodHandleLookup.resolve(caller, methodName, methodType, 1, null);
        }

        public static CallSite resolve(MethodHandles.Lookup caller, String methodName, MethodType methodType, int direct, MethodHandle unsafeAccess_static_getter) throws NoSuchMethodException {
            return MethodHandleLookup.resolve(caller, methodName, methodType, direct, 0, unsafeAccess_static_getter);
        }

        public static CallSite resolve(MethodHandles.Lookup caller, String methodName, MethodType methodType, int direct, int noCallerCheck, MethodHandle unsafeAccess_static_getter) throws NoSuchMethodException {
            return new ConstantCallSite(MethodHandleLookup.lookup(MethodHandleLookup.detectUnsafeAccessHold(MethodHandleLookup.icb(noCallerCheck) ? null : caller, unsafeAccess_static_getter), methodName, methodType, MethodHandleLookup.icb(direct), true));
        }

        private static boolean icb(int v) {
            return v != 0;
        }
    }
}

